<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Lowongan;
use Illuminate\Http\Request;

class LowonganController extends Controller
{
    // Middleware is handled at route level in web.php

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $lowongan = Lowongan::orderBy('created_at', 'desc')->paginate(10);
        return view('admin.lowongan.index', compact('lowongan'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.lowongan.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'judul' => 'required|string|max:255',
            'perusahaan' => 'required|string|max:255',
            'deskripsi' => 'required|string',
            'lokasi' => 'required|string|max:255',
            'tipe_pekerjaan' => 'required|in:full-time,part-time,kontrak,freelance',
            'gaji_min' => 'nullable|numeric|min:0',
            'gaji_max' => 'nullable|numeric|min:0',
            'persyaratan' => 'required|string',
            'kontak' => 'required|string|max:255',
            'batas_lamaran' => 'required|date|after:today',
            'status' => 'required|in:aktif,nonaktif',
        ]);

        Lowongan::create($request->all());

        return redirect()->route('admin.lowongan.index')
            ->with('success', 'Lowongan berhasil dibuat.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Lowongan $lowongan)
    {
        return view('admin.lowongan.show', compact('lowongan'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Lowongan $lowongan)
    {
        return view('admin.lowongan.edit', compact('lowongan'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Lowongan $lowongan)
    {
        $request->validate([
            'judul' => 'required|string|max:255',
            'perusahaan' => 'required|string|max:255',
            'deskripsi' => 'required|string',
            'lokasi' => 'required|string|max:255',
            'tipe_pekerjaan' => 'required|in:full-time,part-time,kontrak,freelance',
            'gaji_min' => 'nullable|numeric|min:0',
            'gaji_max' => 'nullable|numeric|min:0',
            'persyaratan' => 'required|string',
            'kontak' => 'required|string|max:255',
            'batas_lamaran' => 'required|date|after:today',
            'status' => 'required|in:aktif,nonaktif',
        ]);

        $lowongan->update($request->all());

        return redirect()->route('admin.lowongan.index')
            ->with('success', 'Lowongan berhasil diperbarui.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Lowongan $lowongan)
    {
        $lowongan->delete();

        return redirect()->route('admin.lowongan.index')
            ->with('success', 'Lowongan berhasil dihapus.');
    }
}
