<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\View\Composers\AdminComposer;
use App\View\Composers\FrontendComposer;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register View Composer for admin layout
        View::composer('admin.layout', AdminComposer::class);
        
        // Register View Composer for frontend layout
        View::composer('layouts.app', FrontendComposer::class);
    }
}
