<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lowongan', function (Blueprint $table) {
            $table->id();
            $table->string('judul');
            $table->string('perusahaan');
            $table->text('deskripsi');
            $table->string('lokasi');
            $table->string('tipe_pekerjaan'); // full-time, part-time, kontrak
            $table->decimal('gaji_min', 10, 2)->nullable();
            $table->decimal('gaji_max', 10, 2)->nullable();
            $table->text('persyaratan');
            $table->string('kontak');
            $table->date('batas_lamaran');
            $table->enum('status', ['aktif', 'nonaktif', 'expired'])->default('aktif');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lowongan');
    }
};
