<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demografi', function (Blueprint $table) {
            $table->id();
            $table->string('kategori'); // jenis kelamin, usia, pendidikan, pekerjaan, dll
            $table->string('label'); // laki-laki, perempuan, 0-10 tahun, dll
            $table->integer('jumlah');
            $table->text('keterangan')->nullable();
            $table->integer('tahun');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demografi');
    }
};
