<?php

namespace Database\Seeders;

use App\Models\Demografi;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DemografiSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $demografiData = [
            // Data berdasarkan jenis kelamin
            [
                'kategori' => 'Jenis Kelamin',
                'label' => 'Laki-laki',
                'jumlah' => 1250,
                'keterangan' => 'Jumlah penduduk laki-laki',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Jenis Kelamin',
                'label' => 'Perempuan',
                'jumlah' => 1180,
                'keterangan' => 'Jumlah penduduk perempuan',
                'tahun' => 2024,
            ],
            
            // Data berdasarkan usia
            [
                'kategori' => 'Kelompok Usia',
                'label' => '0-14 tahun',
                'jumlah' => 580,
                'keterangan' => 'Anak-anak dan remaja',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Kelompok Usia',
                'label' => '15-64 tahun',
                'jumlah' => 1650,
                'keterangan' => 'Usia produktif',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Kelompok Usia',
                'label' => '65+ tahun',
                'jumlah' => 200,
                'keterangan' => 'Lansia',
                'tahun' => 2024,
            ],
            
            // Data berdasarkan pendidikan
            [
                'kategori' => 'Pendidikan',
                'label' => 'SD/Sederajat',
                'jumlah' => 850,
                'keterangan' => 'Lulusan Sekolah Dasar',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Pendidikan',
                'label' => 'SMP/Sederajat',
                'jumlah' => 620,
                'keterangan' => 'Lulusan Sekolah Menengah Pertama',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Pendidikan',
                'label' => 'SMA/Sederajat',
                'jumlah' => 480,
                'keterangan' => 'Lulusan Sekolah Menengah Atas',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Pendidikan',
                'label' => 'Diploma/Sarjana',
                'jumlah' => 180,
                'keterangan' => 'Lulusan Perguruan Tinggi',
                'tahun' => 2024,
            ],
            
            // Data berdasarkan pekerjaan
            [
                'kategori' => 'Pekerjaan',
                'label' => 'Petani',
                'jumlah' => 680,
                'keterangan' => 'Bekerja di sektor pertanian',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Pekerjaan',
                'label' => 'Pedagang',
                'jumlah' => 320,
                'keterangan' => 'Bekerja di sektor perdagangan',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Pekerjaan',
                'label' => 'PNS/TNI/Polri',
                'jumlah' => 150,
                'keterangan' => 'Pegawai Negeri Sipil dan Militer',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Pekerjaan',
                'label' => 'Swasta',
                'jumlah' => 280,
                'keterangan' => 'Karyawan swasta',
                'tahun' => 2024,
            ],
            [
                'kategori' => 'Pekerjaan',
                'label' => 'Lainnya',
                'jumlah' => 220,
                'keterangan' => 'Pekerjaan lainnya termasuk pensiunan',
                'tahun' => 2024,
            ],
        ];

        foreach ($demografiData as $data) {
            Demografi::create($data);
        }
    }
}
