<?php

namespace Database\Seeders;

use App\Models\Lowongan;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class LowonganSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $lowonganData = [
            [
                'judul' => 'Staff Admin Kantor Desa',
                'perusahaan' => 'Pemerintah Desa',
                'deskripsi' => 'Dibutuhkan staff admin untuk membantu pelayanan administrasi di kantor desa.',
                'lokasi' => 'Kantor Desa',
                'tipe_pekerjaan' => 'Full Time',
                'gaji_min' => 2500000,
                'gaji_max' => 3000000,
                'persyaratan' => 'Minimal SMA/SMK, Bisa mengoperasikan komputer, Domisili sekitar desa',
                'kontak' => 'kepala.desa@webdesa.com',
                'batas_lamaran' => now()->addDays(30),
                'status' => 'aktif',
            ],
            [
                'judul' => 'Operator Warung Internet',
                'perusahaan' => 'Warnet Desa Maju',
                'deskripsi' => 'Dicari operator warnet yang bisa melayani pelanggan dan maintenance komputer.',
                'lokasi' => 'Pusat Desa',
                'tipe_pekerjaan' => 'Part Time',
                'gaji_min' => 1500000,
                'gaji_max' => 2000000,
                'persyaratan' => 'Paham komputer dan internet, Bisa bekerja shift, Komunikatif',
                'kontak' => '081234567890',
                'batas_lamaran' => now()->addDays(20),
                'status' => 'aktif',
            ],
            [
                'judul' => 'Guru Les Privat',
                'perusahaan' => 'Bimbel Cerdas',
                'deskripsi' => 'Dibutuhkan guru les untuk mata pelajaran SD dan SMP.',
                'lokasi' => 'Rumah Siswa',
                'tipe_pekerjaan' => 'Freelance',
                'gaji_min' => 50000,
                'gaji_max' => 100000,
                'persyaratan' => 'Minimal D3, Berpengalaman mengajar, Sabar dan telaten',
                'kontak' => 'bimbelcerdas@gmail.com',
                'batas_lamaran' => now()->addDays(15),
                'status' => 'aktif',
            ],
            [
                'judul' => 'Driver Ojek Online',
                'perusahaan' => 'Ojek Desa',
                'deskripsi' => 'Dicari driver ojek online untuk melayani warga desa.',
                'lokasi' => 'Seluruh Area Desa',
                'tipe_pekerjaan' => 'Freelance',
                'gaji_min' => 100000,
                'gaji_max' => 300000,
                'persyaratan' => 'Punya motor dan SIM C, Kenal area desa, Jujur dan ramah',
                'kontak' => '081234567891',
                'batas_lamaran' => now()->addDays(45),
                'status' => 'aktif',
            ],
        ];

        foreach ($lowonganData as $data) {
            Lowongan::create($data);
        }
    }
}
