// public/assets/js/demografi.js

// Data dummy per tahun & dusun
const dataDemografi = {
  "2024": {
    "semua": {
      usia: [850, 1120, 1950, 603],
      pendidikan: [1300, 900, 700, 150, 300],
      pekerjaan: [1800, 620, 340, 900, 300],
      stunting: [150,350] // Data stunting tambahan
    },
    "baujeng": {
      usia: [200, 350, 700, 120],
      pendidikan: [500, 300, 200, 50, 80],
      pekerjaan: [600, 120, 60, 200, 100],
      stunting: [90, 110] // Data stunting tambahan
    },
    "nyangking": {
      usia: [180, 300, 600, 100],
      pendidikan: [400, 250, 180, 40, 70],
      pekerjaan: [500, 100, 50, 150, 80],
      stunting: [80, 90] // Data stunting tambahan
    },
    "pohkecik": {
      usia: [150, 250, 500, 80],
      pendidikan: [300, 200, 150, 30, 50],
      pekerjaan: [400, 80, 40, 120, 60],
      stunting: [70, 80] // Data stunting tambahan
    },
    "tanggul": {
      usia: [120, 220, 400, 70],
      pendidikan: [200, 150, 100, 20, 30],
      pekerjaan: [250,70,25,80,50],
      stunting: [60,70] // Data stunting tambahan
    },
    "jambe": {
      usia: [110, 200, 350, 60],
      pendidikan: [180, 130, 90, 15, 25],
      pekerjaan: [220, 60, 20, 70, 40],
      stunting: [55, 65] // Data stunting tambahan
    },
    "pekeyongan": {
      usia: [100, 180, 300, 50],
      pendidikan: [160, 120, 80, 10, 20],
      pekerjaan: [200, 50, 15, 60, 30],
      stunting: [50, 60] // Data stunting tambahan
    },
  },
  "2025": {
    "semua": {
      usia: [900, 1200, 2000, 650],
      pendidikan: [1350, 950, 750, 180, 350],
      pekerjaan: [1850, 650, 360, 950, 330],
      stunting: [160, 360] // Data stunting tambahan
    },
    "baujeng": {
      usia: [220, 380, 720, 130],
      pendidikan: [420, 320, 210, 60, 90],
      pekerjaan: [620, 140, 70, 210, 110],
      stunting: [95, 115] // Data stunting tambahan
    },
    "nyangking": {
      usia: [200, 320, 620, 110],
      pendidikan: [450, 270, 190, 50, 80],
      pekerjaan: [520, 110, 60, 160, 90],
      stunting: [85, 95] // Data stunting tambahan
    },
    "pohkecik": {
      usia: [160, 270, 520, 90],
      pendidikan: [350, 220, 160, 40, 60],
      pekerjaan: [420, 90, 50, 130, 70],
      stunting: [75, 85] // Data stunting tambahan
    },
    "tanggul": {
      usia: [130, 230, 420, 80],
      pendidikan: [220, 160, 110, 30, 40], 
      pekerjaan: [270,80,30,90,60],
      stunting: [65,75] // Data stunting tambahan
    },
    "jambe": {
      usia: [120, 210, 370, 70],
      pendidikan: [200, 140, 100, 25, 30],
      pekerjaan: [240, 70, 25, 80, 45],
      stunting: [58, 68] // Data stunting tambahan
    },
    "pekeyongan": {
      usia: [110, 190, 320, 60],
      pendidikan: [180, 130, 90, 20, 25],
      pekerjaan: [210, 60, 20, 70, 35],
      stunting: [52, 62] // Data stunting tambahan
    },
  }
};

function initCharts() {
  let selectedData = dataDemografi["2025"]["semua"];

  const usiaChart = new Chart(document.getElementById('usiaChart'), {
    type: 'pie',
    data: {
      labels: ['Anak-anak', 'Remaja', 'Dewasa', 'Lansia'],
      datasets: [{
        data: selectedData.usia,
        backgroundColor: ['#3b82f6','#10b981','#f59e0b','#ef4444']
      }]
    },
    options: {
      animation: { duration: 1000, easing: 'easeInOutQuart' },
      responsive: true, maintainAspectRatio: false
    }
  });

  const pendidikanChart = new Chart(document.getElementById('pendidikanChart'), {
    type: 'bar',
    data: {
      labels: ['SD', 'SMP', 'SMA', 'Diploma', 'Sarjana'],
      datasets: [{
        label: 'Jumlah Penduduk',
        data: selectedData.pendidikan,
        backgroundColor: ['#3b82f6','#10b981','#f59e0b','#8b5cf6','#ef4444']
      }]
    },
    options: {
      animation: { duration: 1200, easing: 'easeOutBounce' },
      responsive: true, maintainAspectRatio: false,
      plugins: { legend: { display: false } },
      scales: { y: { beginAtZero: true } }
    }
  });

  const pekerjaanChart = new Chart(document.getElementById('pekerjaanChart'), {
    type: 'doughnut',
    data: {
      labels: ['Petani', 'Pedagang', 'PNS', 'Swasta', 'Wirausaha'],
      datasets: [{
        data: selectedData.pekerjaan,
        backgroundColor: ['#10b981','#3b82f6','#f59e0b','#8b5cf6','#ef4444']
      }]
    },
    options: {
      animation: { duration: 1000, animateScale: true, animateRotate: true },
      responsive: true, maintainAspectRatio: false,
      plugins: { legend: { position: 'bottom' } }
    }
  });
  // Grafik Stunting
  const stuntingChart = new Chart(document.getElementById('stuntingChart'), {
    type: 'bar',
    data: {
      labels: ['Stunting', 'Non-Stunting'],
      datasets: [{
        label: 'Jumlah Anak',
        data: selectedData.stunting,
        backgroundColor: ['#ef4444', '#10b981']
      }]
    },
    options: {
      animation: { duration: 1200, easing: 'easeOutBounce' },
      responsive: true, maintainAspectRatio: false,
      plugins: { legend: { display: false } },
      scales: { y: { beginAtZero: true } }
    }
  });

  // Update saat filter berubah
  function updateCharts() {
    const tahun = document.getElementById('tahun').value;
    const dusun = document.getElementById('dusun').value;
    const selected = dataDemografi[tahun][dusun];

    usiaChart.data.datasets[0].data = selected.usia;
    pendidikanChart.data.datasets[0].data = selected.pendidikan;
    pekerjaanChart.data.datasets[0].data = selected.pekerjaan;
    stuntingChart.data.datasets[0].data = selected.stunting;

    usiaChart.update();
    pendidikanChart.update();
    pekerjaanChart.update();
    stuntingChart.update();
  }

  document.getElementById('tahun').addEventListener('change', updateCharts);
  document.getElementById('dusun').addEventListener('change', updateCharts);
}

// Jalankan setelah halaman siap
document.addEventListener("DOMContentLoaded", initCharts);
