@extends('admin.layout')

@section('title', 'Tambah Anggaran Desa')
@section('page-title', 'Tambah Anggaran')

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header">
        <h5 class="mb-0"><i class="fas fa-plus"></i> Form Anggaran</h5>
      </div>
      <div class="card-body">
        <form action="{{ route('admin.anggaran.store') }}" method="POST">
          @csrf
          <div class="row">
            <div class="col-md-6">
              <div class="mb-3">
                <label class="form-label">Keterangan Belanja / Kategori</label>
                <select name="kategori" class="form-select @error('kategori') is-invalid @enderror" required>
                  <option value="">-- Pilih Kategori --</option>
                  <option>Bidang Penyelenggara Pemerintahan Desa</option>
                  <option>Bidang Pelaksanaan Pembangunan Desa</option>
                  <option>Bidang Pembinaan Kemasyarakatan Desa</option>
                  <option>Bidang Pemberdayaan Masyarakat Desa</option>
                  <option>Bidang Penanggulangan Bencana Darurat dan Mendesak Desa</option>
                </select>
                @error('kategori')<div class="invalid-feedback">{{ $message }}</div>@enderror
              </div>
            </div>
            <div class="col-md-6">
              <div class="mb-3">
                <label class="form-label">Jumlah Anggaran (Rp)</label>
                <input type="number" name="jumlah" class="form-control @error('jumlah') is-invalid @enderror" min="0" step="1" placeholder="Contoh: 250000000" required>
                @error('jumlah')<div class="invalid-feedback">{{ $message }}</div>@enderror
              </div>
            </div>
            <div class="col-12">
              <div class="mb-3">
                <label class="form-label">Keterangan</label>
                <textarea name="keterangan" class="form-control @error('keterangan') is-invalid @enderror" rows="3" placeholder="Keterangan tambahan (opsional)"></textarea>
                @error('keterangan')<div class="invalid-feedback">{{ $message }}</div>@enderror
              </div>
            </div>
          </div>
          <div class="d-flex justify-content-between">
            <a href="{{ route('admin.anggaran.index') }}" class="btn btn-secondary">Batal</a>
            <button class="btn btn-primary" type="submit">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection