﻿@extends('admin.layout')

@section('title', 'Transparansi Anggaran')
@section('page-title', 'Transparansi Anggaran / Anggaran Desa')

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">
          <i class="fas fa-money-bill-wave"></i> Daftar Anggaran
        </h5>
        <a href="{{ route('admin.anggaran.create') }}" class="btn btn-primary">
          <i class="fas fa-plus"></i> Tambah Anggaran
        </a>
      </div>

      <div class="card-body">
        @if (session('success'))
          <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <div class="table-responsive">
          <table class="table table-hover align-middle">
            <thead class="table-light">
              <tr>
                <th width="5%">#</th>
                <th width="25%">Kategori</th>
                <th width="20%">Jumlah</th>
                <th>Keterangan</th>
                <th width="20%">Aksi</th>
              </tr>
            </thead>

            <tbody>
              @forelse ($items as $i => $item)
                <tr>
                  <td>{{ $i + 1 }}</td>
                  <td>{{ $item->kategori }}</td>
                  <td>
                    <strong class="text-success">
                      Rp {{ number_format($item->jumlah, 0, ',', '.') }}
                    </strong>
                  </td>
                  <td>{{ $item->keterangan }}</td>
                  <td>
                    <div class="d-flex gap-2">
                      <a href="{{ route('admin.anggaran.edit', $item) }}" class="btn btn-sm btn-warning">
                        <i class="fas fa-edit"></i> Edit
                      </a>
                      <form action="{{ route('admin.anggaran.destroy', $item) }}" method="POST" onsubmit="return confirm('Hapus anggaran ini?')">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-sm btn-danger">
                          <i class="fas fa-trash-alt"></i> Hapus
                        </button>
                      </form>
                    </div>
                  </td>
                </tr>
              @empty
                <tr>
                  <td colspan="5" class="text-center text-muted">
                    Belum ada data anggaran
                  </td>
                </tr>
              @endforelse
            </tbody>

            <tfoot class="table-light">
              <tr>
                <td colspan="2"><strong>Total</strong></td>
                <td colspan="3">
                  <strong class="text-primary">
                    Rp {{ number_format($total, 0, ',', '.') }}
                  </strong>
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
