@extends('admin.layout')

@section('title', 'Edit Data Demografi')
@section('page-title', 'Edit Data Demografi')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-edit"></i> Edit Data Demografi</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.demografi.update', $demografi->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <!-- Kategori -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kategori" class="form-label">Kategori <span class="text-danger">*</span></label>
                                <select class="form-select @error('kategori') is-invalid @enderror" id="kategori" name="kategori" required>
                                    <option value="">Pilih Kategori</option>
                                    <option value="penduduk" {{ old('kategori', $demografi->kategori) == 'penduduk' ? 'selected' : '' }}>Penduduk</option>
                                    <option value="ekonomi" {{ old('kategori', $demografi->kategori) == 'ekonomi' ? 'selected' : '' }}>Ekonomi</option>
                                    <option value="pendidikan" {{ old('kategori', $demografi->kategori) == 'pendidikan' ? 'selected' : '' }}>Pendidikan</option>
                                    <option value="kesehatan" {{ old('kategori', $demografi->kategori) == 'kesehatan' ? 'selected' : '' }}>Kesehatan</option>
                                    <option value="infrastruktur" {{ old('kategori', $demografi->kategori) == 'infrastruktur' ? 'selected' : '' }}>Infrastruktur</option>
                                    <option value="lainnya" {{ old('kategori', $demografi->kategori) == 'lainnya' ? 'selected' : '' }}>Lainnya</option>
                                </select>
                                @error('kategori')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Status -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-select @error('status') is-invalid @enderror" id="status" name="status">
                                    <option value="aktif" {{ old('status', $demografi->status) == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="nonaktif" {{ old('status', $demografi->status) == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Label -->
                    <div class="mb-3">
                        <label for="label" class="form-label">Label/Nama Data <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('label') is-invalid @enderror" 
                               id="label" name="label" value="{{ old('label', $demografi->label) }}" required
                               placeholder="Contoh: Jumlah Penduduk, Tingkat Pendidikan SMA">
                        @error('label')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <!-- Nilai -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nilai" class="form-label">Nilai <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('nilai') is-invalid @enderror" 
                                       id="nilai" name="nilai" value="{{ old('nilai', $demografi->nilai) }}" required
                                       min="0" step="0.01" placeholder="0">
                                @error('nilai')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Satuan -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="satuan" class="form-label">Satuan</label>
                                <input type="text" class="form-control @error('satuan') is-invalid @enderror" 
                                       id="satuan" name="satuan" value="{{ old('satuan', $demografi->satuan) }}" 
                                       placeholder="Contoh: orang, %, unit, rumah">
                                <div class="form-text">Kosongkan jika tidak ada satuan</div>
                                @error('satuan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Deskripsi -->
                    <div class="mb-3">
                        <label for="deskripsi" class="form-label">Deskripsi</label>
                        <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                  id="deskripsi" name="deskripsi" rows="4" 
                                  placeholder="Deskripsi atau keterangan tambahan tentang data ini...">{{ old('deskripsi', $demografi->deskripsi) }}</textarea>
                        @error('deskripsi')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Sumber Data -->
                    <div class="mb-3">
                        <label for="sumber" class="form-label">Sumber Data</label>
                        <input type="text" class="form-control @error('sumber') is-invalid @enderror" 
                               id="sumber" name="sumber" value="{{ old('sumber', $demografi->sumber) }}" 
                               placeholder="Contoh: BPS, Kantor Desa, Survey Internal">
                        @error('sumber')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Tahun Data -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tahun" class="form-label">Tahun Data</label>
                                <input type="number" class="form-control @error('tahun') is-invalid @enderror" 
                                       id="tahun" name="tahun" value="{{ old('tahun', $demografi->tahun) }}" 
                                       min="2000" max="{{ date('Y') + 1 }}">
                                @error('tahun')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Buttons -->
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.demografi.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <div>
                            <a href="{{ route('admin.demografi.show', $demografi->id) }}" class="btn btn-outline-info me-2">
                                <i class="fas fa-eye"></i> Lihat Detail
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Data
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Data History -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-history"></i> Informasi Data</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td><strong>ID Data:</strong></td>
                                <td>{{ $demografi->id }}</td>
                            </tr>
                            <tr>
                                <td><strong>Dibuat:</strong></td>
                                <td>{{ $demografi->created_at->format('d/m/Y H:i') }}</td>
                            </tr>
                            <tr>
                                <td><strong>Terakhir Diupdate:</strong></td>
                                <td>{{ $demografi->updated_at->format('d/m/Y H:i') }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td><strong>Kategori Saat Ini:</strong></td>
                                <td>
                                    <span class="badge bg-info">{{ ucfirst($demografi->kategori) }}</span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Status Saat Ini:</strong></td>
                                <td>
                                    <span class="badge {{ $demografi->status == 'aktif' ? 'bg-success' : 'bg-secondary' }}">
                                        {{ ucfirst($demografi->status) }}
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Nilai Saat Ini:</strong></td>
                                <td>
                                    <strong>{{ number_format($demografi->nilai, 0, ',', '.') }}</strong>
                                    {{ $demografi->satuan ?? '' }}
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-suggest satuan based on kategori
    const kategoriSelect = document.getElementById('kategori');
    const satuanInput = document.getElementById('satuan');
    
    const satuanSuggestions = {
        'penduduk': 'orang',
        'ekonomi': 'rupiah',
        'pendidikan': 'orang',
        'kesehatan': 'orang',
        'infrastruktur': 'unit'
    };
    
    kategoriSelect.addEventListener('change', function() {
        if (satuanInput.value === '' && satuanSuggestions[this.value]) {
            satuanInput.value = satuanSuggestions[this.value];
        }
    });
});
</script>
@endsection