@extends('admin.layout')

@section('title', 'Manajemen Demografi')
@section('page-title', 'Manajemen Data Demografi')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-chart-pie"></i> Data Demografi Desa</h5>
                <a href="{{ route('admin.demografi.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Data
                </a>
            </div>
            <div class="card-body">
                @if($demografi->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="25%">Kategori</th>
                                    <th width="20%">Label</th>
                                    <th width="15%">Jumlah</th>
                                    <th width="20%">Keterangan</th>
                                    <th width="10%">Tahun</th>
                                    <th width="5%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($demografi as $index => $item)
                                    <tr>
                                        <td>{{ $demografi->firstItem() + $index }}</td>
                                        <td>
                                            <span class="badge bg-primary">{{ $item->kategori }}</span>
                                        </td>
                                        <td>
                                            <strong>{{ $item->label }}</strong>
                                        </td>
                                        <td>
                                            <h6 class="mb-0 text-success">{{ number_format($item->jumlah, 0, ',', '.') }}</h6>
                                        </td>
                                        <td>
                                            <small class="text-muted">{{ Str::limit($item->keterangan ?? 'Tidak ada keterangan', 40) }}</small>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ $item->tahun ?? '-' }}</span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('admin.demografi.show', $item->id) }}" 
                                                   class="btn btn-sm btn-info" title="Lihat">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.demografi.edit', $item->id) }}" 
                                                   class="btn btn-sm btn-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.demografi.destroy', $item->id) }}" 
                                                      method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" 
                                                            title="Hapus"
                                                            onclick="return confirm('Yakin ingin menghapus data ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $demografi->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-chart-pie fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Belum ada data demografi</h5>
                        <p class="text-muted">Mulai dengan menambahkan data demografi desa</p>
                        <a href="{{ route('admin.demografi.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Tambah Data
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Quick Stats by Category -->
<div class="row mt-4">
    @php
        $categories = \App\Models\Demografi::select('kategori')
            ->selectRaw('COUNT(*) as total')
            ->selectRaw('SUM(jumlah) as total_jumlah')
            ->groupBy('kategori')
            ->get();
        
        $categoryColors = [
            'Jenis Kelamin' => 'primary',
            'Kelompok Usia' => 'success', 
            'Pendidikan' => 'info',
            'Pekerjaan' => 'warning',
            'Agama' => 'secondary',
            'Lainnya' => 'dark'
        ];
    @endphp
    
    @foreach($categories as $category)
        <div class="col-md-4 mb-3">
            <div class="card bg-{{ $categoryColors[$category->kategori] ?? 'primary' }} text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4>{{ $category->total }}</h4>
                            <p class="mb-0">{{ ucfirst($category->kategori) }}</p>
                            <small>Total: {{ number_format($category->total_jumlah, 0, ',', '.') }}</small>
                        </div>
                        <i class="fas fa-{{ $category->kategori == 'Jenis Kelamin' ? 'venus-mars' : ($category->kategori == 'Kelompok Usia' ? 'user-clock' : ($category->kategori == 'Pendidikan' ? 'graduation-cap' : ($category->kategori == 'Pekerjaan' ? 'briefcase' : ($category->kategori == 'Agama' ? 'place-of-worship' : 'chart-bar')))) }} fa-2x opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>

<!-- Data Summary -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-chart-bar"></i> Ringkasan Data Demografi</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($categories as $category)
                        <div class="col-md-6 mb-3">
                            <h6>{{ $category->kategori }}</h6>
                            @php
                                $categoryData = \App\Models\Demografi::where('kategori', $category->kategori)
                                    ->orderBy('jumlah', 'desc')
                                    ->limit(3)
                                    ->get();
                            @endphp
                            
                            @foreach($categoryData as $data)
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span>{{ $data->label }}</span>
                                    <span class="badge bg-{{ $categoryColors[$category->kategori] ?? 'primary' }}">
                                        {{ number_format($data->jumlah, 0, ',', '.') }}
                                    </span>
                                </div>
                            @endforeach
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endsection