@extends('admin.layout')

@section('title', 'Edit Lowongan Kerja')
@section('page-icon', '<i class="fas fa-edit text-warning me-2"></i>')
@section('page-title', 'Edit Lowongan Kerja')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-edit"></i> Edit Lowongan Kerja</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.lowongan.update', $lowongan->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <!-- Posisi -->
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="posisi" class="form-label">Posisi/Jabatan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('posisi') is-invalid @enderror" 
                                       id="posisi" name="posisi" value="{{ old('posisi', $lowongan->posisi) }}" required
                                       placeholder="Contoh: Staff Admin, Marketing Executive">
                                @error('posisi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Status -->
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-select @error('status') is-invalid @enderror" id="status" name="status">
                                    <option value="aktif" {{ old('status', $lowongan->status) == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="nonaktif" {{ old('status', $lowongan->status) == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                    <option value="expired" {{ old('status', $lowongan->status) == 'expired' ? 'selected' : '' }}>Expired</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Perusahaan -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="perusahaan" class="form-label">Nama Perusahaan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('perusahaan') is-invalid @enderror" 
                                       id="perusahaan" name="perusahaan" value="{{ old('perusahaan', $lowongan->perusahaan) }}" required
                                       placeholder="Nama perusahaan atau instansi">
                                @error('perusahaan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Lokasi -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="lokasi" class="form-label">Lokasi <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('lokasi') is-invalid @enderror" 
                                       id="lokasi" name="lokasi" value="{{ old('lokasi', $lowongan->lokasi) }}" required
                                       placeholder="Kota, Provinsi">
                                @error('lokasi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Deskripsi Singkat -->
                    <div class="mb-3">
                        <label for="deskripsi_singkat" class="form-label">Deskripsi Singkat <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('deskripsi_singkat') is-invalid @enderror" 
                                  id="deskripsi_singkat" name="deskripsi_singkat" rows="3" required
                                  placeholder="Ringkasan singkat tentang posisi ini...">{{ old('deskripsi_singkat', $lowongan->deskripsi_singkat) }}</textarea>
                        <div class="form-text">
                            <span id="charCount">{{ strlen(old('deskripsi_singkat', $lowongan->deskripsi_singkat)) }}</span>/200 karakter
                        </div>
                        @error('deskripsi_singkat')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Persyaratan -->
                    <div class="mb-3">
                        <label for="persyaratan" class="form-label">Persyaratan <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('persyaratan') is-invalid @enderror" 
                                  id="persyaratan" name="persyaratan" rows="5" required
                                  placeholder="- Pendidikan minimal S1&#10;- Pengalaman kerja minimal 2 tahun&#10;- Menguasai Microsoft Office&#10;- Komunikasi yang baik">{{ old('persyaratan', $lowongan->persyaratan) }}</textarea>
                        @error('persyaratan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <!-- Gaji Minimum -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="gaji_min" class="form-label">Gaji Minimum</label>
                                <input type="number" class="form-control @error('gaji_min') is-invalid @enderror" 
                                       id="gaji_min" name="gaji_min" value="{{ old('gaji_min', $lowongan->gaji_min) }}" 
                                       min="0" placeholder="0">
                                @error('gaji_min')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Gaji Maximum -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="gaji_max" class="form-label">Gaji Maximum</label>
                                <input type="number" class="form-control @error('gaji_max') is-invalid @enderror" 
                                       id="gaji_max" name="gaji_max" value="{{ old('gaji_max', $lowongan->gaji_max) }}" 
                                       min="0" placeholder="0">
                                <div class="form-text">Kosongkan jika gaji akan dibicarakan saat interview</div>
                                @error('gaji_max')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Tipe Pekerjaan -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tipe_pekerjaan" class="form-label">Tipe Pekerjaan</label>
                                <select class="form-select @error('tipe_pekerjaan') is-invalid @enderror" id="tipe_pekerjaan" name="tipe_pekerjaan">
                                    <option value="full_time" {{ old('tipe_pekerjaan', $lowongan->tipe_pekerjaan) == 'full_time' ? 'selected' : '' }}>Full Time</option>
                                    <option value="part_time" {{ old('tipe_pekerjaan', $lowongan->tipe_pekerjaan) == 'part_time' ? 'selected' : '' }}>Part Time</option>
                                    <option value="kontrak" {{ old('tipe_pekerjaan', $lowongan->tipe_pekerjaan) == 'kontrak' ? 'selected' : '' }}>Kontrak</option>
                                    <option value="freelance" {{ old('tipe_pekerjaan', $lowongan->tipe_pekerjaan) == 'freelance' ? 'selected' : '' }}>Freelance</option>
                                    <option value="magang" {{ old('tipe_pekerjaan', $lowongan->tipe_pekerjaan) == 'magang' ? 'selected' : '' }}>Magang</option>
                                </select>
                                @error('tipe_pekerjaan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Deadline -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="deadline" class="form-label">Deadline Lamaran <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('deadline') is-invalid @enderror" 
                                       id="deadline" name="deadline" value="{{ old('deadline', $lowongan->deadline ? $lowongan->deadline->format('Y-m-d') : '') }}" required>
                                @error('deadline')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Kontak -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h6 class="mb-0"><i class="fas fa-address-book"></i> Informasi Kontak</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <!-- Nama Kontak -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="kontak_nama" class="form-label">Nama Kontak</label>
                                        <input type="text" class="form-control @error('kontak_nama') is-invalid @enderror" 
                                               id="kontak_nama" name="kontak_nama" value="{{ old('kontak_nama', $lowongan->kontak_nama) }}" 
                                               placeholder="Nama HR atau PIC">
                                        @error('kontak_nama')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <!-- Email Kontak -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="kontak_email" class="form-label">Email Kontak</label>
                                        <input type="email" class="form-control @error('kontak_email') is-invalid @enderror" 
                                               id="kontak_email" name="kontak_email" value="{{ old('kontak_email', $lowongan->kontak_email) }}" 
                                               placeholder="hr@perusahaan.com">
                                        @error('kontak_email')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <!-- Telepon Kontak -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="kontak_telepon" class="form-label">Telepon Kontak</label>
                                        <input type="tel" class="form-control @error('kontak_telepon') is-invalid @enderror" 
                                               id="kontak_telepon" name="kontak_telepon" value="{{ old('kontak_telepon', $lowongan->kontak_telepon) }}" 
                                               placeholder="08123456789">
                                        @error('kontak_telepon')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Buttons -->
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.lowongan.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <div>
                            <a href="{{ route('admin.lowongan.show', $lowongan->id) }}" class="btn btn-outline-info me-2">
                                <i class="fas fa-eye"></i> Lihat Detail
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Lowongan
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Job Info -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-info"></i> Informasi Lowongan</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td><strong>ID Lowongan:</strong></td>
                                <td>{{ $lowongan->id }}</td>
                            </tr>
                            <tr>
                                <td><strong>Dibuat:</strong></td>
                                <td>{{ $lowongan->created_at->format('d/m/Y H:i') }}</td>
                            </tr>
                            <tr>
                                <td><strong>Terakhir Diupdate:</strong></td>
                                <td>{{ $lowongan->updated_at->format('d/m/Y H:i') }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-sm">
                            <tr>
                                <td><strong>Status Saat Ini:</strong></td>
                                <td>
                                    <span class="badge {{ $lowongan->status == 'aktif' ? 'bg-success' : ($lowongan->status == 'expired' ? 'bg-danger' : 'bg-secondary') }}">
                                        {{ ucfirst($lowongan->status) }}
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Deadline:</strong></td>
                                <td>
                                    @if($lowongan->deadline)
                                        {{ $lowongan->deadline->format('d/m/Y') }}
                                        @if($lowongan->deadline->isPast())
                                            <span class="badge bg-danger ms-1">Expired</span>
                                        @elseif($lowongan->deadline->diffInDays() <= 7)
                                            <span class="badge bg-warning ms-1">{{ $lowongan->deadline->diffInDays() }} hari lagi</span>
                                        @endif
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Tipe Pekerjaan:</strong></td>
                                <td>{{ ucfirst(str_replace('_', ' ', $lowongan->tipe_pekerjaan)) }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Character counter for deskripsi_singkat
    const deskripsiSingkat = document.getElementById('deskripsi_singkat');
    const charCount = document.getElementById('charCount');
    
    deskripsiSingkat.addEventListener('input', function() {
        const length = this.value.length;
        charCount.textContent = length;
        
        if (length > 200) {
            charCount.style.color = 'red';
        } else if (length > 180) {
            charCount.style.color = 'orange';
        } else {
            charCount.style.color = 'green';
        }
    });
    
    // Salary range validation
    const gajiMin = document.getElementById('gaji_min');
    const gajiMax = document.getElementById('gaji_max');
    
    function validateSalaryRange() {
        const min = parseInt(gajiMin.value) || 0;
        const max = parseInt(gajiMax.value) || 0;
        
        if (min > 0 && max > 0 && min > max) {
            gajiMax.setCustomValidity('Gaji maximum harus lebih besar dari gaji minimum');
        } else {
            gajiMax.setCustomValidity('');
        }
    }
    
    gajiMin.addEventListener('input', validateSalaryRange);
    gajiMax.addEventListener('input', validateSalaryRange);
    
    // Set minimum date for deadline
    const deadlineInput = document.getElementById('deadline');
    const today = new Date().toISOString().split('T')[0];
    deadlineInput.setAttribute('min', today);
});
</script>
@endsection