@extends('admin.layout')

@section('title', 'Edit Produk')
@section('page-title', 'Edit Produk')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-edit"></i> Edit Produk: {{ $produk->nama }}</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.produk.update', $produk->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <!-- Nama Produk -->
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="nama" class="form-label">Nama Produk <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('nama') is-invalid @enderror" 
                                       id="nama" name="nama" value="{{ old('nama', $produk->nama) }}" required>
                                @error('nama')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Status -->
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-select @error('status') is-invalid @enderror" id="status" name="status">
                                    <option value="aktif" {{ old('status', $produk->status) == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="nonaktif" {{ old('status', $produk->status) == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Deskripsi -->
                    <div class="mb-3">
                        <label for="deskripsi" class="form-label">Deskripsi Singkat</label>
                        <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                  id="deskripsi" name="deskripsi" rows="3" 
                                  placeholder="Deskripsi singkat produk...">{{ old('deskripsi', $produk->deskripsi) }}</textarea>
                        <div class="form-text">
                            <span id="deskripsi-count">0</span>/200 karakter
                        </div>
                        @error('deskripsi')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Detail Produk -->
                    <div class="mb-3">
                        <label for="detail" class="form-label">Detail Produk</label>
                        <textarea class="form-control @error('detail') is-invalid @enderror" 
                                  id="detail" name="detail" rows="6" 
                                  placeholder="Detail lengkap produk...">{{ old('detail', $produk->detail) }}</textarea>
                        @error('detail')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <!-- Harga -->
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="harga" class="form-label">Harga <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" class="form-control @error('harga') is-invalid @enderror" 
                                           id="harga" name="harga" value="{{ old('harga', $produk->harga) }}" 
                                           min="0" step="1000" required>
                                </div>
                                @error('harga')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Stok -->
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="stok" class="form-label">Stok <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('stok') is-invalid @enderror" 
                                       id="stok" name="stok" value="{{ old('stok', $produk->stok) }}" 
                                       min="0" required>
                                @error('stok')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Kategori -->
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="kategori" class="form-label">Kategori</label>
                                <select class="form-select @error('kategori') is-invalid @enderror" id="kategori" name="kategori">
                                    <option value="">Pilih Kategori</option>
                                    <option value="makanan" {{ old('kategori', $produk->kategori) == 'makanan' ? 'selected' : '' }}>Makanan</option>
                                    <option value="minuman" {{ old('kategori', $produk->kategori) == 'minuman' ? 'selected' : '' }}>Minuman</option>
                                    <option value="kerajinan" {{ old('kategori', $produk->kategori) == 'kerajinan' ? 'selected' : '' }}>Kerajinan</option>
                                    <option value="pertanian" {{ old('kategori', $produk->kategori) == 'pertanian' ? 'selected' : '' }}>Pertanian</option>
                                    <option value="lainnya" {{ old('kategori', $produk->kategori) == 'lainnya' ? 'selected' : '' }}>Lainnya</option>
                                </select>
                                @error('kategori')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Upload Gambar -->
                    <div class="mb-3">
                        <label for="gambar" class="form-label">Gambar Produk</label>
                        
                        @php
                            $currentImage = is_array($produk->gambar) ? ($produk->gambar[0] ?? null) : $produk->gambar;
                        @endphp
                        @if($currentImage)
                            <div class="mb-2">
                                <p class="text-muted mb-1">Gambar saat ini:</p>
                                <img src="{{ asset('storage/' . $currentImage) }}" 
                                     alt="{{ $produk->nama }}" 
                                     class="img-thumbnail" 
                                     style="max-width: 200px;">
                            </div>
                        @endif
                        
                        <input type="file" class="form-control @error('gambar') is-invalid @enderror" 
                               id="gambar" name="gambar" accept="image/*">
                        <div class="form-text">Format: JPG, PNG, GIF. Maksimal 2MB. Kosongkan jika tidak ingin mengubah gambar.</div>
                        @error('gambar')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        
                        <!-- Preview Gambar Baru -->
                        <div id="image-preview" class="mt-3" style="display: none;">
                            <p class="text-muted mb-1">Preview gambar baru:</p>
                            <img id="preview-img" src="" alt="Preview" class="img-thumbnail" style="max-width: 200px;">
                        </div>
                    </div>

                    <!-- Kontak Penjual -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="penjual" class="form-label">Nama Penjual</label>
                                <input type="text" class="form-control @error('penjual') is-invalid @enderror" 
                                       id="penjual" name="penjual" value="{{ old('penjual', $produk->penjual) }}" 
                                       placeholder="Nama penjual/kontak">
                                @error('penjual')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kontak_penjual" class="form-label">No. HP/WhatsApp</label>
                                <input type="text" class="form-control @error('kontak_penjual') is-invalid @enderror" 
                                       id="kontak_penjual" name="kontak_penjual" value="{{ old('kontak_penjual', $produk->kontak_penjual) }}" 
                                       placeholder="08xxxxxxxxxx">
                                @error('kontak_penjual')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Info Timestamps -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Dibuat</label>
                                <p class="form-control-plaintext">{{ $produk->created_at->format('d M Y H:i') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Terakhir Diupdate</label>
                                <p class="form-control-plaintext">{{ $produk->updated_at->format('d M Y H:i') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Buttons -->
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.produk.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <div>
                            <a href="{{ route('admin.produk.show', $produk->id) }}" class="btn btn-info me-2">
                                <i class="fas fa-eye"></i> Lihat
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Produk
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Image preview
    const imageInput = document.getElementById('gambar');
    const imagePreview = document.getElementById('image-preview');
    const previewImg = document.getElementById('preview-img');
    
    imageInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                imagePreview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            imagePreview.style.display = 'none';
        }
    });
    
    // Character count for deskripsi
    const deskripsiTextarea = document.getElementById('deskripsi');
    const deskripsiCount = document.getElementById('deskripsi-count');
    
    function updateDeskripsiCount() {
        const count = deskripsiTextarea.value.length;
        deskripsiCount.textContent = count;
        
        if (count > 200) {
            deskripsiCount.classList.add('text-danger');
        } else {
            deskripsiCount.classList.remove('text-danger');
        }
    }
    
    deskripsiTextarea.addEventListener('input', updateDeskripsiCount);
    updateDeskripsiCount(); // Initial count
    
    // Format harga input
    const hargaInput = document.getElementById('harga');
    hargaInput.addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        e.target.value = value;
    });
});
</script>
@endsection