﻿@extends('admin.layout')

@section('title', 'Buat Profil Desa')
@section('page-title', 'Buat Profil Desa')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-plus"></i> Buat Profil Desa</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.profil.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <!-- Informasi Dasar -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-info-circle"></i> Informasi Dasar</h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nama_desa" class="form-label">Nama Desa <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('nama_desa') is-invalid @enderror" 
                                       id="nama_desa" name="nama_desa" value="{{ old('nama_desa') }}" required>
                                @error('nama_desa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kecamatan" class="form-label">Kecamatan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('kecamatan') is-invalid @enderror" 
                                       id="kecamatan" name="kecamatan" value="{{ old('kecamatan') }}" required>
                                @error('kecamatan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kabupaten" class="form-label">Kabupaten <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('kabupaten') is-invalid @enderror" 
                                       id="kabupaten" name="kabupaten" value="{{ old('kabupaten') }}" required>
                                @error('kabupaten')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="provinsi" class="form-label">Provinsi <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('provinsi') is-invalid @enderror" 
                                       id="provinsi" name="provinsi" value="{{ old('provinsi') }}" required>
                                @error('provinsi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="alamat" class="form-label">Alamat Lengkap <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                          id="alamat" name="alamat" rows="2" required>{{ old('alamat') }}</textarea>
                                @error('alamat')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Kontak -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-phone"></i> Informasi Kontak</h6>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="kode_pos" class="form-label">Kode Pos</label>
                                <input type="text" class="form-control @error('kode_pos') is-invalid @enderror" 
                                       id="kode_pos" name="kode_pos" value="{{ old('kode_pos') }}">
                                @error('kode_pos')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="telepon" class="form-label">Telepon</label>
                                <input type="text" class="form-control @error('telepon') is-invalid @enderror" 
                                       id="telepon" name="telepon" value="{{ old('telepon') }}">
                                @error('telepon')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                       id="email" name="email" value="{{ old('email') }}">
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="website" class="form-label">Website</label>
                                <input type="url" class="form-control @error('website') is-invalid @enderror" 
                                       id="website" name="website" value="{{ old('website') }}">
                                @error('website')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Statistik -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-chart-bar"></i> Statistik Desa</h6>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="luas_wilayah" class="form-label">Luas Wilayah (km²)</label>
                                <input type="number" step="0.01" class="form-control @error('luas_wilayah') is-invalid @enderror" 
                                       id="luas_wilayah" name="luas_wilayah" value="{{ old('luas_wilayah') }}">
                                @error('luas_wilayah')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="jumlah_dusun" class="form-label">Dusun</label>
                                <input type="number" class="form-control @error('jumlah_dusun') is-invalid @enderror" 
                                       id="jumlah_dusun" name="jumlah_dusun" value="{{ old('jumlah_dusun') }}">
                                @error('jumlah_dusun')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="jumlah_rw" class="form-label">Rukun Warga (RW)</label>
                                <input type="number" class="form-control @error('jumlah_rw') is-invalid @enderror" 
                                       id="jumlah_rw" name="jumlah_rw" value="{{ old('jumlah_rw') }}">
                                @error('jumlah_rw')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="jumlah_rt" class="form-label">Rukun Tetangga (RT)</label>
                                <input type="number" class="form-control @error('jumlah_rt') is-invalid @enderror" 
                                       id="jumlah_rt" name="jumlah_rt" value="{{ old('jumlah_rt') }}">
                                @error('jumlah_rt')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Visi Misi -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-eye"></i> Visi & Misi</h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="visi" class="form-label">Visi <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('visi') is-invalid @enderror" 
                                          id="visi" name="visi" rows="4" required>{{ old('visi') }}</textarea>
                                @error('visi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="misi" class="form-label">Misi <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('misi') is-invalid @enderror" 
                                          id="misi" name="misi" rows="4" required>{{ old('misi') }}</textarea>
                                @error('misi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="sejarah" class="form-label">Sejarah Desa <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('sejarah') is-invalid @enderror" 
                                          id="sejarah" name="sejarah" rows="5" required>{{ old('sejarah') }}</textarea>
                                @error('sejarah')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Sambutan Kepala Desa -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-user"></i> Sambutan Kepala Desa</h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kepala_desa" class="form-label">Nama Kepala Desa <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('kepala_desa') is-invalid @enderror" 
                                       id="kepala_desa" name="kepala_desa" value="{{ old('kepala_desa') }}" required>
                                @error('kepala_desa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="foto_kepala_desa" class="form-label">Foto Kepala Desa</label>
                                <input type="file" class="form-control @error('foto_kepala_desa') is-invalid @enderror" 
                                       id="foto_kepala_desa" name="foto_kepala_desa" accept="image/*">
                                @error('foto_kepala_desa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="sambutan_kepala_desa" class="form-label">Sambutan Kepala Desa</label>
                                <textarea class="form-control @error('sambutan_kepala_desa') is-invalid @enderror" id="sambutan_kepala_desa" name="sambutan_kepala_desa" rows="6">{{ old('sambutan_kepala_desa') }}</textarea>
                                @error('sambutan_kepala_desa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        
                        
                        
                        
                        
                    </div>

                    <!-- Media -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-images"></i> Media</h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="logo_desa" class="form-label">Logo Desa</label>
                                <input type="file" class="form-control @error('logo_desa') is-invalid @enderror" 
                                       id="logo_desa" name="logo_desa" accept="image/*">
                                @error('logo_desa')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="foto_kantor" class="form-label">Foto Kantor Desa</label>
                                <input type="file" class="form-control @error('foto_kantor') is-invalid @enderror" 
                                       id="foto_kantor" name="foto_kantor" accept="image/*">
                                @error('foto_kantor')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.profil.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Simpan Profil
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

