@extends('admin.layout')

@section('title', 'Staf Desa')

@section('content')
<div class="content-wrapper">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>Staf / Aparat Desa</h2>
        <a href="{{ route('admin.staf.create') }}" class="btn btn-primary"><i class="fa fa-plus"></i> Tambah Staf</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card">
        <div class="card-body">
            <div class="row">
                @forelse($staf as $i => $item)
                    <div class="col-md-3 mb-4">
                        <div class="card h-100">
                            @if(!empty($item['foto']))
                                <img src="{{ asset('storage/' . $item['foto']) }}" class="card-img-top" style="height:180px;object-fit:cover;">
                            @else
                                <div class="d-flex align-items-center justify-content-center" style="height:180px;background:#f1f1f1;">
                                    <i class="fa fa-user fa-3x text-secondary"></i>
                                </div>
                            @endif
                            <div class="card-body">
                                <h5 class="card-title mb-1">{{ $item['nama'] }}</h5>
                                <p class="card-text text-muted">{{ $item['jabatan'] }}</p>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.staf.edit', $i) }}" class="btn btn-sm btn-warning"><i class="fa fa-edit"></i> Edit</a>
                                    <form action="{{ route('admin.staf.destroy', $i) }}" method="POST" onsubmit="return confirm('Hapus staf ini?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i> Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-12">
                        <div class="alert alert-info">Belum ada data staf tambahan.</div>
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</div>
@endsection