@extends('layouts.app')
@section('title', 'Berita Karangtaruna')
@section('content')

<!-- Section Headline & Daftar Berita -->
<section class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8 grid grid-cols-1 md:grid-cols-3 gap-8">

  <!-- Kolom Kiri (Headline Utama) -->
  <div class="relative md:col-span-2 order-2 md:order-1 rounded-2xl overflow-hidden shadow-lg">
    <img src="{{ asset('img/berita/berita header.webp') }}" 
         alt="Gambar Headline"
         class="w-full h-[350px] sm:h-[400px] md:h-[500px] object-cover">

    <!-- Overlay teks -->
    <div class="absolute inset-0 flex flex-col justify-end p-6 sm:p-8 bg-gradient-to-t from-black/80 via-black/50 to-transparent">
      <h2 class="text-2xl sm:text-3xl md:text-4xl font-extrabold text-white mb-3 drop-shadow-lg">
        Karangtaruna Gelar Festival Pemuda 2025
      </h2>
      <p class="text-gray-200 text-sm sm:text-base md:text-lg leading-relaxed max-w-2xl">
        Festival Pemuda menghadirkan berbagai lomba seni, olahraga, serta pameran UMKM lokal untuk memperkuat persaudaraan antarwarga.
      </p>
    </div>
  </div>

  <!-- Kolom Kanan (Daftar Berita Vertikal) -->
  <div class="flex flex-col gap-6 order-1 md:order-2">

    <!-- Item 1 -->
    <div class="flex gap-4 items-start bg-white rounded-2xl shadow-md hover:shadow-xl transition duration-300 p-4">
      <div class="w-28 h-20 sm:w-32 sm:h-24 flex-shrink-0 overflow-hidden rounded-xl">
        <img src="{{ asset('img/berita/berita pelatihan.jpg') }}" alt="Item 1" class="w-full h-full object-cover hover:scale-105 transition duration-300">
      </div>
      <div>
        <h3 class="font-semibold text-gray-900 text-base sm:text-lg mb-1">Pelatihan Wirausaha Pemuda Desa</h3>
        <p class="text-gray-600 text-sm leading-snug">
          Karangtaruna mengadakan pelatihan wirausaha untuk membekali pemuda desa dengan keterampilan bisnis kreatif dan mandiri.
        </p>
      </div>
    </div>

    <!-- Item 2 -->
    <div class="flex gap-4 items-start bg-white rounded-2xl shadow-md hover:shadow-xl transition duration-300 p-4">
      <div class="w-28 h-20 sm:w-32 sm:h-24 flex-shrink-0 overflow-hidden rounded-xl">
        <img src="{{ asset('img/berita/volly.jpg') }}" alt="Item 2" class="w-full h-full object-cover hover:scale-105 transition duration-300">
      </div>
      <div>
        <h3 class="font-semibold text-gray-900 text-base sm:text-lg mb-1">Lomba Voli Antar RW Meriah</h3>
        <p class="text-gray-600 text-sm leading-snug">
          Turnamen voli antar RW sukses digelar dengan antusiasme warga, sekaligus ajang mempererat kebersamaan pemuda.
        </p>
      </div>
    </div>

    <!-- Item 3 -->
    <div class="flex gap-4 items-start bg-white rounded-2xl shadow-md hover:shadow-xl transition duration-300 p-4">
      <div class="w-28 h-20 sm:w-32 sm:h-24 flex-shrink-0 overflow-hidden rounded-xl">
        <img src="{{ asset('img/berita/bersih sungai.jpg') }}" alt="Item 3" class="w-full h-full object-cover hover:scale-105 transition duration-300">
      </div>
      <div>
        <h3 class="font-semibold text-gray-900 text-base sm:text-lg mb-1">Aksi Bersih Sungai</h3>
        <p class="text-gray-600 text-sm leading-snug">
          Pemuda Karangtaruna turun langsung membersihkan bantaran sungai demi menjaga kelestarian lingkungan sekitar.
        </p>
      </div>
    </div>

  </div>
</section>

<!-- Section Berita Lainnya -->
<section class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
  <h2 class="text-3xl font-extrabold text-gray-900 mb-8 text-center">Berita Lainnya</h2>

  <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">

    <!-- Berita 1 -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-xl transition duration-300 overflow-hidden">
      <img src="{{ asset('img/berita/bazar.jpg') }}" alt="Berita 1" class="w-full h-48 object-cover hover:scale-105 transition duration-300">
      <div class="p-6">
        <h3 class="font-semibold text-gray-900 text-lg mb-2">Bazar UMKM Karangtaruna</h3>
        <p class="text-gray-600 text-sm leading-relaxed mb-4">
          Warga berbondong-bondong menghadiri bazar produk UMKM yang digelar oleh Karangtaruna di balai desa.
        </p>
        <a href="#" class="text-blue-600 hover:underline font-medium">Baca Selengkapnya &rarr;</a>
      </div>
    </div>

    <!-- Berita 2 -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-xl transition duration-300 overflow-hidden">
      <img src="{{ asset('img/berita/santunan.jpg') }}" alt="Berita 2" class="w-full h-48 object-cover hover:scale-105 transition duration-300">
      <div class="p-6">
        <h3 class="font-semibold text-gray-900 text-lg mb-2">Santunan Anak Yatim</h3>
        <p class="text-gray-600 text-sm leading-relaxed mb-4">
          Dalam rangka memperingati Tahun Baru Islam, Karangtaruna memberikan santunan kepada anak yatim di desa.
        </p>
        <a href="#" class="text-blue-600 hover:underline font-medium">Baca Selengkapnya &rarr;</a>
      </div>
    </div>

    <!-- Berita 3 -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-xl transition duration-300 overflow-hidden">
      <img src="{{ asset('img/berita/digitalmarketing.jpg') }}" alt="Berita 3" class="w-full h-48 object-cover hover:scale-105 transition duration-300">
      <div class="p-6">
        <h3 class="font-semibold text-gray-900 text-lg mb-2">Pelatihan Digital Marketing</h3>
        <p class="text-gray-600 text-sm leading-relaxed mb-4">
          Karangtaruna melatih pemuda desa agar bisa memasarkan produk lokal melalui platform digital.
        </p>
        <a href="#" class="text-blue-600 hover:underline font-medium">Baca Selengkapnya &rarr;</a>
      </div>
    </div>

    <!-- Berita 4 -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-xl transition duration-300 overflow-hidden">
      <img src="{{ asset('img/berita/donordarah.jpg') }}" alt="Berita 4" class="w-full h-48 object-cover hover:scale-105 transition duration-300">
      <div class="p-6">
        <h3 class="font-semibold text-gray-900 text-lg mb-2">Donor Darah Pemuda</h3>
        <p class="text-gray-600 text-sm leading-relaxed mb-4">
          Kegiatan donor darah berhasil mengumpulkan ratusan kantong darah dari para sukarelawan muda.
        </p>
        <a href="#" class="text-blue-600 hover:underline font-medium">Baca Selengkapnya &rarr;</a>
      </div>
    </div>

    <!-- Berita 5 -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-xl transition duration-300 overflow-hidden">
      <img src="{{ asset('img/berita/pentas seni.jpg') }}" alt="Berita 5" class="w-full h-48 object-cover hover:scale-105 transition duration-300">
      <div class="p-6">
        <h3 class="font-semibold text-gray-900 text-lg mb-2">Pentas Seni Remaja</h3>
        <p class="text-gray-600 text-sm leading-relaxed mb-4">
          Pertunjukan drama dan musik oleh remaja Karangtaruna mendapat sambutan hangat dari masyarakat.
        </p>
        <a href="#" class="text-blue-600 hover:underline font-medium">Baca Selengkapnya &rarr;</a>
      </div>
    </div>

    <!-- Berita 6 -->
    <div class="bg-white rounded-2xl shadow-md hover:shadow-xl transition duration-300 overflow-hidden">
      <img src="{{ asset('img/berita/lomba mural.jpg') }}" alt="Berita 6" class="w-full h-48 object-cover hover:scale-105 transition duration-300">
      <div class="p-6">
        <h3 class="font-semibold text-gray-900 text-lg mb-2">Lomba Mural Pemuda</h3>
        <p class="text-gray-600 text-sm leading-relaxed mb-4">
          Kreativitas anak muda dituangkan dalam lomba mural yang menghiasi tembok-tembok desa dengan karya seni indah.
        </p>
        <a href="#" class="text-blue-600 hover:underline font-medium">Baca Selengkapnya &rarr;</a>
      </div>
    </div>

  </div>

  <!-- Button Muat Selanjutnya -->
  <div class="mt-12 text-center">
    <button class="bg-green-800 text-white px-6 py-3 rounded-full hover:bg-green-900 transition duration-300 font-semibold shadow-lg">
      Muat Selanjutnya
    </button>
  </div>
</section>
@endsection
