@extends('layouts.app')

@section('title', $berita->judul . ' - Berita Desa Baujeng')

@section('content')

<!-- Breadcrumb -->
<nav class="bg-gray-50 py-4">
  <div class="max-w-7xl mx-auto px-6">
    <ol class="flex items-center space-x-2 text-sm">
      <li><a href="{{ route('home') }}" class="text-blue-600 hover:text-blue-800">Beranda</a></li>
      <li class="text-gray-500">/</li>
      <li><a href="{{ route('berita') }}" class="text-blue-600 hover:text-blue-800">Berita</a></li>
      <li class="text-gray-500">/</li>
      <li class="text-gray-700 font-medium">{{ Str::limit($berita->judul, 50) }}</li>
    </ol>
  </div>
</nav>

<!-- Article Content -->
<article class="max-w-4xl mx-auto px-6 py-12">
  <!-- Article Header -->
  <header class="mb-8">
    <div class="flex items-center text-sm text-gray-500 mb-4">
      <span class="bg-blue-100 text-blue-700 px-3 py-1 rounded-full text-xs font-medium">
        {{ $berita->kategori ?? 'Umum' }}
      </span>
      <span class="mx-3">•</span>
      <time datetime="{{ $berita->published_at ? $berita->published_at->format('Y-m-d') : $berita->created_at->format('Y-m-d') }}">
        {{ $berita->published_at ? $berita->published_at->format('d F Y') : $berita->created_at->format('d F Y') }}
      </time>
      <span class="mx-3">•</span>
      <span>Oleh: {{ $berita->penulis ?? 'Admin' }}</span>
    </div>
    
    <h1 class="text-3xl md:text-4xl font-bold text-gray-900 leading-tight mb-6">
      {{ $berita->judul }}
    </h1>
    
    @if($berita->gambar)
    <div class="aspect-video overflow-hidden rounded-2xl mb-6">
      <img src="{{ asset('storage/' . $berita->gambar) }}" 
           alt="{{ $berita->judul }}" 
           class="w-full h-full object-cover">
    </div>
    @endif
  </header>

  <!-- Article Body -->
  <div class="prose prose-lg max-w-none">
    {!! $berita->konten !!}
  </div>

  <!-- Article Footer -->
  <footer class="mt-12 pt-8 border-t border-gray-200">
    <div class="flex items-center justify-between">
      <div class="text-sm text-gray-500">
        <p>Dipublikasikan: {{ $berita->published_at ? $berita->published_at->format('d F Y, H:i') : $berita->created_at->format('d F Y, H:i') }}</p>
        @if($berita->updated_at != $berita->created_at)
        <p>Diperbarui: {{ $berita->updated_at->format('d F Y, H:i') }}</p>
        @endif
      </div>
      
      <a href="{{ route('berita') }}" 
         class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
        Kembali ke Berita
      </a>
    </div>
  </footer>
</article>

<!-- Related Articles -->
@if($relatedBerita->count() > 0)
<section class="bg-gray-50 py-16">
  <div class="max-w-7xl mx-auto px-6">
    <h2 class="text-2xl md:text-3xl font-bold text-gray-800 mb-8 text-center">Berita Terkait</h2>
    
    <div class="grid md:grid-cols-3 gap-8">
      @foreach($relatedBerita as $item)
      <article class="bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-shadow">
        @if($item->gambar)
        <div class="aspect-video overflow-hidden">
          <img src="{{ asset('storage/' . $item->gambar) }}" 
               alt="{{ $item->judul }}" 
               class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
        </div>
        @else
        <div class="aspect-video bg-gradient-to-br from-blue-500 to-blue-700 flex items-center justify-center">
          <span class="text-white text-3xl">📰</span>
        </div>
        @endif
        
        <div class="p-6">
          <div class="text-sm text-gray-500 mb-2">
            {{ $item->published_at ? $item->published_at->format('d M Y') : $item->created_at->format('d M Y') }}
          </div>
          
          <h3 class="text-lg font-bold text-gray-800 mb-3 line-clamp-2">
            <a href="{{ route('berita.detail', $item->slug) }}" class="hover:text-blue-600 transition-colors">
              {{ $item->judul }}
            </a>
          </h3>
          
          <p class="text-gray-600 text-sm line-clamp-3">
            {{ Str::limit(strip_tags($item->konten), 100) }}
          </p>
        </div>
      </article>
      @endforeach
    </div>
  </div>
</section>
@endif

@endsection

@push('styles')
<style>
.prose {
  color: #374151;
  line-height: 1.75;
}

.prose p {
  margin-bottom: 1.25rem;
}

.prose h2 {
  font-size: 1.5rem;
  font-weight: 700;
  margin-top: 2rem;
  margin-bottom: 1rem;
  color: #1f2937;
}

.prose h3 {
  font-size: 1.25rem;
  font-weight: 600;
  margin-top: 1.5rem;
  margin-bottom: 0.75rem;
  color: #1f2937;
}

.prose ul, .prose ol {
  margin-bottom: 1.25rem;
  padding-left: 1.5rem;
}

.prose li {
  margin-bottom: 0.5rem;
}

.line-clamp-2 {
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
}

.line-clamp-3 {
  display: -webkit-box;
  -webkit-line-clamp: 3;
  -webkit-box-orient: vertical;
  overflow: hidden;
}
</style>
@endpush