@extends('layouts.app')

@section('title', 'Pemerintahan Desa Baujeng')

@section('content')

<!-- Hero Section -->
<section class="relative bg-green-700 text-white py-20 shadow-xl">
  <div class="max-w-6xl mx-auto px-6 text-center">
    <h1 class="text-4xl md:text-5xl font-extrabold mb-4">Kontak Pemerintahan Desa Baujeng</h1>
    <p class="text-lg md:text-xl opacity-90 max-w-2xl mx-auto">
      Hubungi kami untuk informasi lebih lanjut atau Pemerintahan Desa Baujeng di alamat berikut.
    </p>
  </div>
  <div class="absolute bottom-0 left-0 right-0">
    <svg class="w-full h-16 text-white" viewBox="0 0 1440 320" preserveAspectRatio="none" fill="currentColor">
      <path d="M0,160L48,170.7C96,181,192,203,288,218.7C384,235,480,245,576,245.3C672,245,768,235,864,224C960,213,1056,203,1152,181.3C1248,160,1344,128,1392,112L1440,96L1440,320L0,320Z"></path>
    </svg>
  </div>
</section>

<!-- Kontak Utama -->
<section class="max-w-7xl mx-auto px-6 py-16 grid lg:grid-cols-2 gap-12">
  
  <!-- Info Kontak -->
  <div class="bg-white p-8 rounded-2xl shadow-lg hover:shadow-2xl transition">
    <h2 class="text-3xl font-bold text-green-700 mb-6">Informasi Kontak</h2>
    <ul class="space-y-6 text-gray-700">
      <li class="flex items-start space-x-4">
        <span class="bg-green-100 text-green-700 p-3 rounded-full">
          📍
        </span>
        <p><strong>Alamat:</strong><br>Jl. Raya Baujeng, Desa Baujeng, Pasuruan</p>
      </li>
      <li class="flex items-start space-x-4">
        <span class="bg-green-100 text-green-700 p-3 rounded-full">
          ☎️
        </span>
        <p><strong>Telepon:</strong><br>
          <a href="tel:+628123456789" class="text-green-600 hover:underline">
            +62 812-3456-789
          </a>
        </p>
      </li>
      <li class="flex items-start space-x-4">
        <span class="bg-green-100 text-green-700 p-3 rounded-full">
          📧
        </span>
        <p><strong>Email:</strong><br>
          <a href="mailto:karangtaruna.beji@gmail.com" class="text-green-600 hover:underline">
            pemdes.baujeng@gmail.com
          </a>
        </p>
      </li>
      <li class="flex items-start space-x-4">
        <span class="bg-green-100 text-green-700 p-3 rounded-full">
          ⏰
        </span>
        <p><strong>Jam Kerja:</strong><br>Senin - Jumat, 08.00 - 16.00 WIB</p>
      </li>
    </ul>
  </div>

  <!-- Formulir -->
  <div class="bg-white p-8 rounded-2xl shadow-lg hover:shadow-2xl transition">
    <h2 class="text-3xl font-bold text-green-700 mb-6">Kirim Pesan</h2>
    <form action="#" method="POST" class="space-y-5">
      <div>
        <label class="block text-gray-700 font-medium">Nama</label>
        <input type="text" name="nama" required 
               class="w-full p-3 border rounded-lg focus:ring-2 focus:ring-green-600 focus:outline-none">
      </div>
      <div>
        <label class="block text-gray-700 font-medium">Email</label>
        <input type="email" name="email" required 
               class="w-full p-3 border rounded-lg focus:ring-2 focus:ring-green-600 focus:outline-none">
      </div>
      <div>
        <label class="block text-gray-700 font-medium">Pesan</label>
        <textarea name="pesan" rows="5" required 
                  class="w-full p-3 border rounded-lg focus:ring-2 focus:ring-green-600 focus:outline-none"></textarea>
      </div>
      <button type="submit" 
              class="w-full bg-green-700 text-white py-3 rounded-lg font-semibold text-lg hover:bg-green-800 transition">
        Kirim Pesan
      </button>
    </form>
  </div>

</section>

<!-- Google Maps -->
<section class="w-full">
  <iframe 
    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3952.123456789!2d112.733333!3d-7.616667!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x123456789abcdef!2sDesa%20Baujeng!5e0!3m2!1sid!2sid!4v1634567890123!5m2!1sid!2sid" 
    width="100%" height="400" style="border:0;" allowfullscreen="" loading="lazy">
  </iframe>
</section>

@endsection
