<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Sambutan Kepala Desa Baujeng')</title>
    
    <!-- Favicon -->
    @if($profilDesa && $profilDesa->logo_desa)
        <link rel="icon" type="image/png" href="{{ asset('storage/' . $profilDesa->logo_desa) }}">
    @else
        <link rel="icon" type="image/x-icon" href="{{ asset('img/icon.png') }}">
    @endif
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @yield('styles')
</head>
<body class="bg-gray-50 text-gray-800 flex flex-col min-h-screen">
    <!-- Navbar -->
    <nav class="bg-green-700 text-white" x-data="{ open: false }">
        <div class="max-w-6xl mx-auto flex justify-between items-center px-4 py-3">
            
            <!-- Logo -->
            <a href="{{url("/")}}" class="flex items-center gap-3">
                @if($profilDesa && $profilDesa->logo_desa)
                    <img src="{{ asset('storage/' . $profilDesa->logo_desa) }}" alt="Logo Desa" class="h-11 w-10 object-contain"/>
                @else
                    <img src="{{ asset('img/icon.png') }}" alt="Logo Desa" class="h-11 w-10"/>
                @endif
                <div>
                    <h1 class="font-semibold">
                        @if($profilDesa && $profilDesa->nama_desa)
                            Pemerintahan Desa {{ $profilDesa->nama_desa }}
                        @else
                            Pemerintahan Desa Baujeng
                        @endif
                    </h1>
                    <p class="text-sm text-white/80">
                        @if($profilDesa && $profilDesa->kecamatan && $profilDesa->kabupaten)
                            Kecamatan {{ $profilDesa->kecamatan }}, Kabupaten {{ $profilDesa->kabupaten }}
                        @else
                            Kecamatan Beji, Kabupaten Pasuruan
                        @endif
                    </p>
                </div>
            </a>

            <!-- Menu Desktop -->
            <ul class="hidden md:flex gap-6 text-sm font-medium">
                <li><a href="{{url("/")}}" class="pb-1 hover:text-yellow-300 {{ request()->is('/') ? 'border-b-2 border-yellow-300' : '' }}">Beranda</a></li>
                <li><a href="{{url("/berita")}}" class="pb-1 hover:text-yellow-300 {{ request()->is('berita*') ? 'border-b-2 border-yellow-300' : '' }}">Wartadesa</a></li>
                <li><a href="{{url("/profil")}}" class="pb-1 hover:text-yellow-300 {{ request()->is('profil*') ? 'border-b-2 border-yellow-300' : '' }}">Profil</a></li>
                <li><a href="{{url("/demografi")}}" class="pb-1 hover:text-yellow-300 {{ request()->is('demografi*') ? 'border-b-2 border-yellow-300' : '' }}">Demografi</a></li>
                <li><a href="{{url("/produk")}}" class="pb-1 hover:text-yellow-300 {{ request()->is('produk*') ? 'border-b-2 border-yellow-300' : '' }}">Produk UMKM</a></li>
                <li><a href="{{url("/lowongan")}}" class="pb-1 hover:text-yellow-300 {{ request()->is('lowongan*') ? 'border-b-2 border-yellow-300' : '' }}">Lowongan Kerja</a></li>
                <li><a href="{{url("/kontak")}}" class="pb-1 hover:text-yellow-300 {{ request()->is('kontak*') ? 'border-b-2 border-yellow-300' : '' }}">Kontak</a></li>
            </ul>

            <!-- Hamburger -->
            <button @click="open = !open" class="md:hidden focus:outline-none">
                <template x-if="!open">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round"
                              d="M4 6h16M4 12h16M4 18h16"/>
                    </svg>
                </template>
                <template x-if="open">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round"
                              d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </template>
            </button>
        </div>

        <!-- Menu Mobile -->
        <div x-show="open" x-transition class="md:hidden bg-green-800 px-4 py-3 space-y-2">
            <a href="{{url("/")}}" class="block hover:text-yellow-300 {{ request()->is('/') ? 'text-yellow-300 font-semibold' : '' }}">Beranda</a>
            <a href="{{url("/profil")}}" class="block hover:text-yellow-300 {{ request()->is('profil*') ? 'text-yellow-300 font-semibold' : '' }}">Profil</a>
            <a href="{{url("/berita")}}" class="block hover:text-yellow-300 {{ request()->is('berita*') ? 'text-yellow-300 font-semibold' : '' }}">Wartadesa</a>            
            <a href="{{url("/demografi")}}" class="block hover:text-yellow-300 {{ request()->is('demografi*') ? 'text-yellow-300 font-semibold' : '' }}">Demografi</a>
            <a href="{{url("/produk")}}" class="block hover:text-yellow-300 {{ request()->is('produk*') ? 'text-yellow-300 font-semibold' : '' }}">Produk UMKM</a>
            <a href="{{url("/lowongan")}}" class="block hover:text-yellow-300 {{ request()->is('lowongan*') ? 'text-yellow-300 font-semibold' : '' }}">Lowongan Kerja</a>
            <a href="{{url("/kontak")}}" class="block hover:text-yellow-300 {{ request()->is('kontak*') ? 'text-yellow-300 font-semibold' : '' }}">Kontak</a>
        </div>
    </nav>

    <!-- Content -->
    <main class="@yield('main_class', 'flex-1 max-w-6xl mx-auto px-4 py-6')">
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="bg-white border-t mt-8">
        <div class="max-w-6xl mx-auto px-4 py-6 flex flex-col md:flex-row justify-between items-center gap-4">
            <p class="text-sm text-gray-600">© 2025 Desa Baujeng Kecamatan Beji. Semua hak dilindungi.</p>
            <div class="flex gap-4 text-sm">
                <a href="#" class="text-gray-600 hover:text-green-700">Kebijakan Privasi</a>
                <a href="#" class="text-gray-600 hover:text-green-700">Sitemap</a>
            </div>
        </div>
    </footer>

    <!-- Alpine.js -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>   
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
@yield('scripts')

</body>
</html>

