@extends('layouts.app')

@section('title', $lowongan->posisi . ' - Lowongan Kerja Desa Baujeng')

@section('content')

<!-- Breadcrumb -->
<nav class="bg-gray-50 py-4">
  <div class="max-w-7xl mx-auto px-6">
    <ol class="flex items-center space-x-2 text-sm">
      <li><a href="{{ route('home') }}" class="text-orange-600 hover:text-orange-800">Beranda</a></li>
      <li class="text-gray-500">/</li>
      <li><a href="{{ route('lowongan') }}" class="text-orange-600 hover:text-orange-800">Lowongan</a></li>
      <li class="text-gray-500">/</li>
      <li class="text-gray-700 font-medium">{{ Str::limit($lowongan->posisi, 50) }}</li>
    </ol>
  </div>
</nav>

<!-- Job Detail -->
<section class="max-w-4xl mx-auto px-6 py-12">
  <!-- Job Header -->
  <div class="bg-white rounded-2xl shadow-lg p-8 mb-8">
    <div class="flex items-center gap-3 mb-4">
      <span class="bg-orange-100 text-orange-700 px-3 py-1 rounded-full text-sm font-medium">
        {{ $lowongan->jenis_pekerjaan ?? 'Full Time' }}
      </span>
      @php
        $isExpiringSoon = $lowongan->batas_lamaran && $lowongan->batas_lamaran->diffInDays(now()) <= 7;
        $isExpired = $lowongan->batas_lamaran && $lowongan->batas_lamaran < now();
      @endphp
      @if($isExpired)
      <span class="bg-red-100 text-red-700 px-3 py-1 rounded-full text-sm font-medium">
        Expired
      </span>
      @elseif($isExpiringSoon)
      <span class="bg-yellow-100 text-yellow-700 px-3 py-1 rounded-full text-sm font-medium">
        Segera Berakhir
      </span>
      @else
      <span class="bg-green-100 text-green-700 px-3 py-1 rounded-full text-sm font-medium">
        Aktif
      </span>
      @endif
    </div>
    
    <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
      {{ $lowongan->posisi }}
    </h1>
    
    <div class="grid md:grid-cols-2 gap-6 mb-6">
      <div class="space-y-3">
        <div class="flex items-center text-gray-600">
          <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-4m-5 0H3m2 0h4M9 7h6m-6 4h6m-6 4h6"></path>
          </svg>
          <span class="font-medium">{{ $lowongan->perusahaan }}</span>
        </div>
        
        @if($lowongan->lokasi)
        <div class="flex items-center text-gray-600">
          <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
          </svg>
          <span>{{ $lowongan->lokasi }}</span>
        </div>
        @endif
      </div>
      
      <div class="space-y-3">
        @if($lowongan->gaji_min || $lowongan->gaji_max)
        <div class="flex items-center text-gray-600">
          <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
          </svg>
          <span class="font-medium text-orange-600">
            @if($lowongan->gaji_min && $lowongan->gaji_max)
              Rp {{ number_format($lowongan->gaji_min, 0, ',', '.') }} - Rp {{ number_format($lowongan->gaji_max, 0, ',', '.') }}
            @elseif($lowongan->gaji_min)
              Minimal Rp {{ number_format($lowongan->gaji_min, 0, ',', '.') }}
            @else
              Maksimal Rp {{ number_format($lowongan->gaji_max, 0, ',', '.') }}
            @endif
          </span>
        </div>
        @endif
        
        @if($lowongan->batas_lamaran)
        <div class="flex items-center text-gray-600">
          <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
          </svg>
          <span class="{{ $isExpiringSoon ? 'text-yellow-600 font-medium' : ($isExpired ? 'text-red-600 font-medium' : '') }}">
            Batas: {{ $lowongan->batas_lamaran->format('d F Y') }}
          </span>
        </div>
        @endif
      </div>
    </div>
    
    @if(!$isExpired)
    <div class="bg-orange-50 p-4 rounded-lg">
      <p class="text-orange-800 font-medium mb-2">Tertarik dengan posisi ini?</p>
      <p class="text-orange-700 text-sm mb-3">
        Hubungi kami untuk informasi lebih lanjut atau kirim lamaran Anda.
      </p>
      <div class="flex flex-wrap gap-3">
        <a href="https://wa.me/628123456789?text=Halo, saya tertarik dengan lowongan {{ $lowongan->posisi }} di {{ $lowongan->perusahaan }}" 
           target="_blank"
           class="inline-flex items-center px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition-colors">
          <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 24 24">
            <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.885 3.488"/>
          </svg>
          WhatsApp
        </a>
        <a href="mailto:karangtaruna.beji@gmail.com?subject=Lamaran {{ $lowongan->posisi }}&body=Halo, saya tertarik dengan lowongan {{ $lowongan->posisi }} di {{ $lowongan->perusahaan }}" 
           class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
          <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
          </svg>
          Email
        </a>
      </div>
    </div>
    @else
    <div class="bg-red-50 p-4 rounded-lg">
      <p class="text-red-800 font-medium">Lowongan ini sudah berakhir</p>
      <p class="text-red-700 text-sm">
        Batas waktu lamaran telah terlewati. Silakan cek lowongan lainnya yang masih tersedia.
      </p>
    </div>
    @endif
  </div>

  <!-- Job Description -->
  @if($lowongan->deskripsi)
  <div class="bg-white rounded-2xl shadow-lg p-8 mb-8">
    <h2 class="text-2xl font-bold text-gray-800 mb-4">Deskripsi Pekerjaan</h2>
    <div class="prose prose-gray max-w-none">
      {!! nl2br(e($lowongan->deskripsi)) !!}
    </div>
  </div>
  @endif

  <!-- Requirements -->
  @if($lowongan->persyaratan)
  <div class="bg-white rounded-2xl shadow-lg p-8 mb-8">
    <h2 class="text-2xl font-bold text-gray-800 mb-4">Persyaratan</h2>
    <div class="prose prose-gray max-w-none">
      {!! nl2br(e($lowongan->persyaratan)) !!}
    </div>
  </div>
  @endif

  <!-- Back Button -->
  <div class="text-center">
    <a href="{{ route('lowongan') }}" 
       class="inline-flex items-center px-6 py-3 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
      <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
      </svg>
      Kembali ke Lowongan
    </a>
  </div>
</section>

@endsection

@push('styles')
<style>
.prose {
  color: #374151;
  line-height: 1.75;
}

.prose p {
  margin-bottom: 1rem;
}

.prose ul, .prose ol {
  margin-bottom: 1rem;
  padding-left: 1.5rem;
}

.prose li {
  margin-bottom: 0.5rem;
}
</style>
@endpush