@extends('layouts.app')
@section('title', 'Produk Karangtaruna')
@section('content')

<!-- Header -->
<section class="relative bg-green-700 text-white py-20 shadow-lg">
  <div class="max-w-6xl mx-auto px-6 text-center">
    <h1 class="text-4xl md:text-5xl font-extrabold mb-4">Produk Unggulan UMKM</h1>
    <p class="text-lg md:text-xl opacity-90">
      Jelajahi berbagai produk berkualitas dari UMKM di Desa Baujeng Kecamatan Beji, Kabupaten Pasuruan.
    </p>
  </div>
  <div class="absolute bottom-0 left-0 right-0">
    <svg class="w-full h-16 text-white" viewBox="0 0 1440 320" preserveAspectRatio="none" fill="currentColor">
      <path d="M0,160L48,170.7C96,181,192,203,288,218.7C384,235,480,245,576,245.3C672,245,768,235,864,224C960,213,1056,203,1152,181.3C1248,160,1344,128,1392,112L1440,96L1440,320L0,320Z"></path>
    </svg>
  </div>
</section>
<!-- Daftar Produk -->
<section class="max-w-7xl mx-auto py-12 px-4">
  <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">

    <!-- DTF Printing -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/print.jpg') }}" alt="DTF Printing" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">DTF Printing</h4>
      <p class="text-gray-600 text-sm mb-3">Cetak sablon Direct to Film (DTF) berkualitas tinggi, tahan lama, cocok untuk berbagai kain.</p>
      <span class="text-green-700 font-bold text-lg">Rp 20.000</span>
      <a href="{{ url('/dtf') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- Sepatu Handmade -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/sepatu.jpg') }}" alt="Sepatu Handmade" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Sepatu Handmade</h4>
      <p class="text-gray-600 text-sm mb-3">Sepatu buatan tangan dengan bahan berkualitas, nyaman digunakan sehari-hari.</p>
      <span class="text-green-700 font-bold text-lg">Rp 150.000</span>
      <a href="{{ url('/sepatu') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- Kopi Robusta -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/kopi.jpg') }}" alt="Kopi Robusta" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Kopi Robusta</h4>
      <p class="text-gray-600 text-sm mb-3">Kopi robusta khas Desa Baujeng, aroma kuat, rasa khas dengan karakter mendalam.</p>
      <span class="text-green-700 font-bold text-lg">Rp 35.000</span>
      <a href="{{ url('/kopi') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- Tempe Sehat -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/tempe.jpg') }}" alt="Tempe Sehat" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Tempe Sehat</h4>
      <p class="text-gray-600 text-sm mb-3">Tempe kedelai fermentasi alami tanpa pengawet, kaya protein nabati.</p>
      <span class="text-green-700 font-bold text-lg">Rp 10.000</span>
      <a href="{{ url('/tempe') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>
  </div>
  <!-- Button Lihat Semua Produk -->
  <div class="mt-10 mb-10 text-center">
    <a href="{{ url('/produk') }}" style="background-color: #327A6D;" class="inline-flex items-center gap-2 px-6 py-3 text-white rounded hover:bg-green-700 transition text-sm font-semibold shadow">
      Lihat Semua Produk
      <i class="fas fa-arrow-right"></i>
    </a>
  </div>
</section>

@endsection