@extends('layouts.app')
@section('title', 'Checkout - Desa Baujeng')

@section('content')
<section class="max-w-5xl mx-auto py-12 px-4">
  <h2 class="text-3xl font-bold text-green-800 mb-8 text-center">Checkout</h2>

  <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
    
    <!-- Ringkasan Produk -->
    <div class="bg-white shadow rounded-xl p-6">
      <h3 class="text-xl font-semibold text-gray-800 mb-4">Ringkasan Pesanan</h3>
      <div class="flex items-center gap-4 mb-4">
        <img src="{{ asset('img/Produk/print.jpg') }}" 
             alt="DTF Printing" 
             class="w-24 h-24 object-cover rounded-lg shadow">
        <div>
          <h4 class="font-semibold text-lg text-gray-700">DTF Printing</h4>
          <span class="text-green-700 font-bold">Rp 20.000 / pcs</span>
        </div>
      </div>

      <div class="mb-4">
        <label for="jumlah" class="block text-gray-600 mb-1">Jumlah</label>
        <input type="number" id="jumlah" name="jumlah" value="1" min="1" 
               class="w-24 border rounded-lg px-3 py-2 focus:ring-2 focus:ring-green-500">
      </div>

      <div class="border-t pt-4 mt-4">
        <p class="flex justify-between text-gray-700">
          <span>Subtotal</span>
          <span class="font-semibold">Rp 20.000</span>
        </p>
        <p class="flex justify-between text-gray-700">
          <span>Ongkir</span>
          <span class="font-semibold">Rp 10.000</span>
        </p>
        <p class="flex justify-between text-lg font-bold text-green-700 mt-2">
          <span>Total</span>
          <span>Rp 30.000</span>
        </p>
      </div>
    </div>

    <!-- Form Checkout -->
    <div class="bg-white shadow rounded-xl p-6">
      <h3 class="text-xl font-semibold text-gray-800 mb-4">Data Pembeli</h3>
      <form action="{{ url('/checkout/proses') }}" method="POST">
        @csrf
        <div class="mb-4">
          <label class="block text-gray-600 mb-1">Nama Lengkap</label>
          <input type="text" name="nama" required 
                 class="w-full border rounded-lg px-3 py-2 focus:ring-2 focus:ring-green-500">
        </div>

        <div class="mb-4">
          <label class="block text-gray-600 mb-1">Alamat Lengkap</label>
          <textarea name="alamat" rows="3" required 
                    class="w-full border rounded-lg px-3 py-2 focus:ring-2 focus:ring-green-500"></textarea>
        </div>

        <div class="mb-4">
          <label class="block text-gray-600 mb-1">Nomor HP</label>
          <input type="text" name="telepon" required 
                 class="w-full border rounded-lg px-3 py-2 focus:ring-2 focus:ring-green-500">
        </div>

        <div class="mb-6">
          <label class="block text-gray-600 mb-1">Metode Pembayaran</label>
          <select name="pembayaran" required 
                  class="w-full border rounded-lg px-3 py-2 focus:ring-2 focus:ring-green-500">
            <option value="">-- Pilih Pembayaran --</option>
            <option value="cod">Cash on Delivery (COD)</option>
            <option value="transfer">Transfer Bank</option>
            <option value="ewallet">E-Wallet (OVO, Dana, Gopay)</option>
          </select>
        </div>

        <button type="submit" 
                class="w-full bg-green-700 hover:bg-green-800 text-white px-6 py-3 rounded-lg shadow-lg transition">
          ✅ Proses Pesanan
        </button>
      </form>
    </div>
  </div>
</section>
@endsection
