@extends('layouts.app')

@section('title', $produk->nama . ' - Produk UMKM Desa Baujeng')

@section('content')

<!-- Breadcrumb -->
<nav class="bg-gray-50 py-4">
  <div class="max-w-7xl mx-auto px-6">
    <ol class="flex items-center space-x-2 text-sm">
      <li><a href="{{ route('home') }}" class="text-purple-600 hover:text-purple-800">Beranda</a></li>
      <li class="text-gray-500">/</li>
      <li><a href="{{ route('produk') }}" class="text-purple-600 hover:text-purple-800">Produk</a></li>
      <li class="text-gray-500">/</li>
      <li class="text-gray-700 font-medium">{{ Str::limit($produk->nama, 50) }}</li>
    </ol>
  </div>
</nav>

<!-- Product Detail -->
<section class="max-w-7xl mx-auto px-6 py-12">
  <div class="grid lg:grid-cols-2 gap-12">
    <!-- Product Image -->
    <div class="space-y-4">
      @php
        $mainImg = is_array($produk->gambar) ? ($produk->gambar[0] ?? null) : $produk->gambar;
      @endphp
      @if($mainImg)
      <div class="aspect-square overflow-hidden rounded-2xl bg-gray-100">
        <img src="{{ asset('storage/' . $mainImg) }}" 
             alt="{{ $produk->nama }}" 
             class="w-full h-full object-cover">
      </div>
      @else
      <div class="aspect-square bg-gradient-to-br from-purple-500 to-purple-700 rounded-2xl flex items-center justify-center">
        <span class="text-white text-6xl">🛍️</span>
      </div>
      @endif
    </div>

    <!-- Product Info -->
    <div class="space-y-6">
      <div>
        <div class="flex items-center gap-3 mb-4">
          <span class="bg-purple-100 text-purple-700 px-3 py-1 rounded-full text-sm font-medium">
            {{ $produk->kategori }}
          </span>
          @if($produk->stok > 0)
          <span class="bg-green-100 text-green-700 px-3 py-1 rounded-full text-sm font-medium">
            Tersedia
          </span>
          @else
          <span class="bg-red-100 text-red-700 px-3 py-1 rounded-full text-sm font-medium">
            Stok Habis
          </span>
          @endif
        </div>
        
        <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
          {{ $produk->nama }}
        </h1>
        
        <div class="text-4xl font-bold text-purple-600 mb-6">
          Rp {{ number_format($produk->harga, 0, ',', '.') }}
        </div>
      </div>

      <!-- Product Details -->
      <div class="space-y-4">
        <div class="grid grid-cols-2 gap-4 text-sm">
          <div class="bg-gray-50 p-4 rounded-lg">
            <span class="text-gray-600">Stok Tersedia</span>
            <p class="font-semibold text-lg">{{ $produk->stok > 0 ? $produk->stok . ' unit' : 'Habis' }}</p>
          </div>
          <div class="bg-gray-50 p-4 rounded-lg">
            <span class="text-gray-600">Kategori</span>
            <p class="font-semibold text-lg">{{ $produk->kategori }}</p>
          </div>
        </div>

        @if($produk->produsen)
        <div class="bg-purple-50 p-4 rounded-lg">
          <span class="text-purple-700 font-medium">Produsen:</span>
          <p class="text-purple-800 font-semibold">{{ $produk->produsen }}</p>
        </div>
        @endif
      </div>

      <!-- Description -->
      <div>
        <h3 class="text-xl font-bold text-gray-800 mb-3">Deskripsi Produk</h3>
        <div class="prose prose-gray max-w-none">
          {!! nl2br(e($produk->deskripsi)) !!}
        </div>
      </div>

      <!-- Contact Info -->
      <div class="bg-green-50 p-6 rounded-2xl">
        <h3 class="text-lg font-bold text-green-800 mb-3">Tertarik dengan produk ini?</h3>
        <p class="text-green-700 mb-4">
          Hubungi kami untuk informasi lebih lanjut atau pemesanan produk ini.
        </p>
        <div class="flex flex-wrap gap-3">
          <a href="https://wa.me/628123456789?text=Halo, saya tertarik dengan produk {{ $produk->nama }}" 
             target="_blank"
             class="inline-flex items-center px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition-colors">
            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24">
              <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.885 3.488"/>
            </svg>
            WhatsApp
          </a>
          <a href="tel:+628123456789" 
             class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
            </svg>
            Telepon
          </a>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Related Products -->
@if($relatedProduk->count() > 0)
<section class="bg-gray-50 py-16">
  <div class="max-w-7xl mx-auto px-6">
    <h2 class="text-2xl md:text-3xl font-bold text-gray-800 mb-8 text-center">Produk Serupa</h2>
    
    <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-6">
      @foreach($relatedProduk as $item)
      <div class="bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-shadow">
        @php
          $relImg = is_array($item->gambar) ? ($item->gambar[0] ?? null) : $item->gambar;
        @endphp
        @if($relImg)
        <div class="aspect-square overflow-hidden">
          <img src="{{ asset('storage/' . $relImg) }}" 
               alt="{{ $item->nama }}" 
               class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
        </div>
        @else
        <div class="aspect-square bg-gradient-to-br from-purple-500 to-purple-700 flex items-center justify-center">
          <span class="text-white text-3xl">🛍️</span>
        </div>
        @endif
        
        <div class="p-4">
          <h3 class="font-bold text-gray-800 mb-2 line-clamp-2">
            <a href="{{ route('produk.detail', $item->slug) }}" class="hover:text-purple-600 transition-colors">
              {{ $item->nama }}
            </a>
          </h3>
          
          <div class="flex items-center justify-between">
            <span class="text-lg font-bold text-purple-600">
              Rp {{ number_format($item->harga, 0, ',', '.') }}
            </span>
            @if($item->stok > 0)
            <span class="bg-green-100 text-green-700 px-2 py-1 rounded text-xs">
              Tersedia
            </span>
            @else
            <span class="bg-red-100 text-red-700 px-2 py-1 rounded text-xs">
              Habis
            </span>
            @endif
          </div>
        </div>
      </div>
      @endforeach
    </div>
  </div>
</section>
@endif

@endsection

@push('styles')
<style>
.prose {
  color: #374151;
  line-height: 1.75;
}

.prose p {
  margin-bottom: 1rem;
}

.line-clamp-2 {
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
}
</style>
@endpush