@extends('layouts.app')
@section('title', 'Desa Baujeng')
@section('content')

 <!-- Detail Produk -->
  <section class="max-w-6xl mx-auto py-12 px-4 grid grid-cols-1 md:grid-cols-2 gap-8">
    <!-- Gambar Produk -->
    <div class="bg-white rounded-xl shadow p-4">
      <img src="{{ asset('img/Produk/print.jpg') }}" alt="DTF Printing" 
           class="w-full h-80 object-cover rounded-lg shadow-md hover:scale-105 transition duration-300">
    </div>

    <!-- Informasi Produk -->
    <div>
      <h2 class="text-3xl font-bold text-green-800 mb-3">DTF Printing</h2>
      <p class="text-gray-600 mb-4">
        Cetak sablon <strong>Direct to Film (DTF)</strong> dengan kualitas tinggi, warna tajam, 
        dan tahan lama. Cocok untuk kaos, totebag, jaket, dan berbagai media kain.
      </p>
      <ul class="list-disc list-inside text-gray-700 mb-4">
        <li>Bahan tinta premium</li>
        <li>Warna tidak mudah luntur</li>
        <li>Cocok untuk berbagai jenis kain</li>
      </ul>
      <span class="block text-2xl font-bold text-green-700 mb-6">Rp 20.000 / pcs</span>

      <!-- Tombol Beli -->
      <div class="flex gap-4">
        <a href="{{ url('/checkout') }}" 
           class="bg-green-700 hover:bg-green-800 text-white px-6 py-3 rounded-lg shadow-lg transition">
          🛒 Beli Sekarang
        </a>
        <a href="{{ url('/produk') }}" 
           class="bg-gray-200 hover:bg-gray-300 text-gray-700 px-6 py-3 rounded-lg shadow-lg transition">
          ⬅ Kembali
        </a>
      </div>
    </div>
  </section>

<!-- Produk Lainnya -->
<section class="max-w-6xl mx-auto py-12 px-4">
  <h3 class="text-2xl font-bold text-green-800 mb-6 text-center">Produk Lainnya</h3>
  <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
    
    <!-- Sepatu -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/sepatu.jpg') }}" alt="Sepatu Handmade" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-lg text-gray-800">Sepatu Handmade</h4>
      <span class="text-green-700 font-bold">Rp 150.000</span>
      <a href="{{ url('/sepatu') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- Kopi -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/kopi.jpg') }}" alt="Kopi Robusta" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-lg text-gray-800">Kopi Robusta</h4>
      <span class="text-green-700 font-bold">Rp 35.000</span>
      <a href="{{ url('/kopi') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- Tempe Sehat -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/tempe.jpg') }}" alt="Tempe Sehat" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-lg text-gray-800">Tempe Sehat</h4>
      <span class="text-green-700 font-bold">Rp 10.000</span>
      <a href="{{ url('/tempe') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

  </div>
</section>

@endsection