@extends('layouts.app')
@section('title', 'Tempe Sehat - Desa Baujeng')
@section('content')

<!-- Detail Produk -->
<section class="max-w-6xl mx-auto py-12 px-4 grid grid-cols-1 md:grid-cols-2 gap-8">
  <!-- Gambar Produk -->
  <div class="bg-white rounded-xl shadow p-4">
    <img src="{{ asset('img/Produk/tempe.jpg') }}" alt="Tempe Sehat" 
         class="w-full h-80 object-cover rounded-lg shadow-md hover:scale-105 transition duration-300">
  </div>

  <!-- Informasi Produk -->
  <div>
    <h2 class="text-3xl font-bold text-green-800 mb-3">Tempe Sehat</h2>
    <p class="text-gray-600 mb-4">
      <strong>Tempe Sehat Desa Baujeng</strong> dibuat dari kedelai pilihan yang difermentasi 
      secara alami tanpa bahan pengawet. Kaya akan protein nabati, serat, serta nutrisi 
      yang baik untuk kesehatan tubuh.
    </p>
    <ul class="list-disc list-inside text-gray-700 mb-4">
      <li>Bahan kedelai lokal berkualitas</li>
      <li>Tanpa bahan pengawet</li>
      <li>Kaya protein & baik untuk pencernaan</li>
    </ul>
    <span class="block text-2xl font-bold text-green-700 mb-6">Rp 10.000 / papan</span>

    <!-- Tombol Beli -->
    <div class="flex gap-4">
      <a href="{{ url('/checkout') }}" 
         class="bg-green-700 hover:bg-green-800 text-white px-6 py-3 rounded-lg shadow-lg transition">
        🛒 Beli Sekarang
      </a>
      <a href="{{ url('/produk') }}" 
         class="bg-gray-200 hover:bg-gray-300 text-gray-700 px-6 py-3 rounded-lg shadow-lg transition">
        ⬅ Kembali
      </a>
    </div>
  </div>
</section>

<!-- Produk Lainnya -->
<section class="max-w-6xl mx-auto py-12 px-4">
  <h3 class="text-2xl font-bold text-green-800 mb-6 text-center">Produk Lainnya</h3>
  <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">

    <!-- DTF Printing -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/print.jpg') }}" alt="DTF Printing" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-lg text-gray-800">DTF Printing</h4>
      <span class="text-green-700 font-bold">Rp 20.000</span>
      <a href="{{ url('/dtf') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- Sepatu Handmade -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/sepatu.jpg') }}" alt="Sepatu Handmade" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-lg text-gray-800">Sepatu Handmade</h4>
      <span class="text-green-700 font-bold">Rp 150.000</span>
      <a href="{{ url('/sepatu') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- Kopi Robusta -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-4 hover:scale-105 transition">
      <img src="{{ asset('img/Produk/kopi.jpg') }}" alt="Kopi Robusta" 
           class="w-full h-48 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-lg text-gray-800">Kopi Robusta</h4>
      <span class="text-green-700 font-bold">Rp 35.000</span>
      <a href="{{ url('/kopi') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

  </div>
</section>

@endsection
