@extends('layouts.app')

@section('title', 'Tentang Desa Baujeng')

@section('content')

<!-- Hero Section -->
<section class="relative bg-green-700 text-white py-20 shadow-xl">
  <div class="max-w-6xl mx-auto px-6 text-center">
    <h1 class="text-4xl md:text-5xl font-extrabold mb-4">Tentang Desa Baujeng</h1>
    <p class="text-lg md:text-xl opacity-90 max-w-2xl mx-auto">
      Mengenal lebih dekat profil dan demografi Desa Baujeng, Kecamatan Beji, Kabupaten Pasuruan
    </p>
  </div>
  <div class="absolute bottom-0 left-0 right-0">
    <svg class="w-full h-16 text-white" viewBox="0 0 1440 320" preserveAspectRatio="none" fill="currentColor">
      <path d="M0,160L48,170.7C96,181,192,203,288,218.7C384,235,480,245,576,245.3C672,245,768,235,864,224C960,213,1056,203,1152,181.3C1248,160,1344,128,1392,112L1440,96L1440,320L0,320Z"></path>
    </svg>
  </div>
</section>

<!-- Profil Desa -->
<section class="max-w-7xl mx-auto px-6 py-16">
  <div class="text-center mb-12">
    <h2 class="text-3xl md:text-4xl font-bold text-gray-800 mb-4">Profil Desa Baujeng</h2>
    <p class="text-lg text-gray-600 max-w-3xl mx-auto">
      Desa Baujeng merupakan salah satu desa di Kecamatan Beji, Kabupaten Pasuruan yang memiliki potensi besar dalam bidang pertanian dan industri kreatif.
    </p>
  </div>

  <div class="grid lg:grid-cols-2 gap-12 items-center mb-16">
    <div>
      <h3 class="text-2xl font-bold text-green-700 mb-4">Visi Desa</h3>
      <p class="text-gray-700 mb-6">
        "Mewujudkan Desa Baujeng yang maju, mandiri, dan sejahtera berdasarkan nilai-nilai gotong royong dan kearifan lokal."
      </p>
      
      <h3 class="text-2xl font-bold text-green-700 mb-4">Misi Desa</h3>
      <ul class="text-gray-700 space-y-2">
        <li>• Meningkatkan kualitas pelayanan publik yang prima</li>
        <li>• Mengembangkan potensi ekonomi lokal dan UMKM</li>
        <li>• Melestarikan budaya dan kearifan lokal</li>
        <li>• Meningkatkan kualitas sumber daya manusia</li>
        <li>• Menjaga kelestarian lingkungan hidup</li>
      </ul>
    </div>
    
    <div class="bg-green-50 p-8 rounded-2xl">
      <h3 class="text-2xl font-bold text-green-700 mb-6">Data Umum</h3>
      <div class="space-y-4">
        <div class="flex justify-between">
          <span class="font-medium">Luas Wilayah:</span>
          <span>2.5 km²</span>
        </div>
        <div class="flex justify-between">
          <span class="font-medium">Jumlah Dusun:</span>
          <span>4 Dusun</span>
        </div>
        <div class="flex justify-between">
          <span class="font-medium">Jumlah RT:</span>
          <span>12 RT</span>
        </div>
        <div class="flex justify-between">
          <span class="font-medium">Jumlah RW:</span>
          <span>4 RW</span>
        </div>
        <div class="flex justify-between">
          <span class="font-medium">Kode Pos:</span>
          <span>67154</span>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Demografi -->
<section class="bg-gray-50 py-16">
  <div class="max-w-7xl mx-auto px-6">
    <div class="text-center mb-12">
      <h2 class="text-3xl md:text-4xl font-bold text-gray-800 mb-4">Data Demografi</h2>
      <p class="text-lg text-gray-600">
        Informasi kependudukan dan demografi Desa Baujeng
      </p>
    </div>

    <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
      <!-- Jenis Kelamin -->
      @if($demografiJenisKelamin->count() > 0)
      <div class="bg-white p-6 rounded-2xl shadow-lg">
        <h3 class="text-xl font-bold text-green-700 mb-4">Jenis Kelamin</h3>
        @foreach($demografiJenisKelamin as $data)
        <div class="flex justify-between mb-2">
          <span>{{ $data->label }}:</span>
          <span class="font-semibold">{{ number_format($data->jumlah) }}</span>
        </div>
        @endforeach
      </div>
      @endif

      <!-- Kelompok Usia -->
      @if($demografiUsia->count() > 0)
      <div class="bg-white p-6 rounded-2xl shadow-lg">
        <h3 class="text-xl font-bold text-green-700 mb-4">Kelompok Usia</h3>
        @foreach($demografiUsia as $data)
        <div class="flex justify-between mb-2">
          <span>{{ $data->label }}:</span>
          <span class="font-semibold">{{ number_format($data->jumlah) }}</span>
        </div>
        @endforeach
      </div>
      @endif

      <!-- Pendidikan -->
      @if($demografiPendidikan->count() > 0)
      <div class="bg-white p-6 rounded-2xl shadow-lg">
        <h3 class="text-xl font-bold text-green-700 mb-4">Pendidikan</h3>
        @foreach($demografiPendidikan as $data)
        <div class="flex justify-between mb-2">
          <span>{{ $data->label }}:</span>
          <span class="font-semibold">{{ number_format($data->jumlah) }}</span>
        </div>
        @endforeach
      </div>
      @endif

      <!-- Pekerjaan -->
      @if($demografiPekerjaan->count() > 0)
      <div class="bg-white p-6 rounded-2xl shadow-lg">
        <h3 class="text-xl font-bold text-green-700 mb-4">Pekerjaan</h3>
        @foreach($demografiPekerjaan as $data)
        <div class="flex justify-between mb-2">
          <span>{{ $data->label }}:</span>
          <span class="font-semibold">{{ number_format($data->jumlah) }}</span>
        </div>
        @endforeach
      </div>
      @endif
    </div>
  </div>
</section>

<!-- Struktur Pemerintahan -->
<section class="max-w-7xl mx-auto px-6 py-16">
  <div class="text-center mb-12">
    <h2 class="text-3xl md:text-4xl font-bold text-gray-800 mb-4">Struktur Pemerintahan</h2>
    <p class="text-lg text-gray-600">
      Susunan perangkat desa dan struktur organisasi pemerintahan Desa Baujeng
    </p>
  </div>

  <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
    <div class="bg-white p-6 rounded-2xl shadow-lg text-center">
      <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
        <span class="text-2xl">👨‍💼</span>
      </div>
      <h3 class="text-xl font-bold text-gray-800 mb-2">Kepala Desa</h3>
      <p class="text-gray-600">Bapak Ahmad Suryanto</p>
    </div>

    <div class="bg-white p-6 rounded-2xl shadow-lg text-center">
      <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
        <span class="text-2xl">📋</span>
      </div>
      <h3 class="text-xl font-bold text-gray-800 mb-2">Sekretaris Desa</h3>
      <p class="text-gray-600">Ibu Siti Aminah</p>
    </div>

    <div class="bg-white p-6 rounded-2xl shadow-lg text-center">
      <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
        <span class="text-2xl">💰</span>
      </div>
      <h3 class="text-xl font-bold text-gray-800 mb-2">Bendahara</h3>
      <p class="text-gray-600">Bapak Joko Widodo</p>
    </div>

    <div class="bg-white p-6 rounded-2xl shadow-lg text-center">
      <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
        <span class="text-2xl">🏛️</span>
      </div>
      <h3 class="text-xl font-bold text-gray-800 mb-2">Kaur Pemerintahan</h3>
      <p class="text-gray-600">Bapak Bambang Sutrisno</p>
    </div>

    <div class="bg-white p-6 rounded-2xl shadow-lg text-center">
      <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
        <span class="text-2xl">🏗️</span>
      </div>
      <h3 class="text-xl font-bold text-gray-800 mb-2">Kaur Pembangunan</h3>
      <p class="text-gray-600">Bapak Eko Prasetyo</p>
    </div>

    <div class="bg-white p-6 rounded-2xl shadow-lg text-center">
      <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
        <span class="text-2xl">👥</span>
      </div>
      <h3 class="text-xl font-bold text-gray-800 mb-2">Kaur Kesejahteraan</h3>
      <p class="text-gray-600">Ibu Dewi Sartika</p>
    </div>
  </div>
</section>

@endsection