
<?php $__env->startSection('title', 'Pemerintahan Desa Baujeng'); ?>

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />
<style>
  /* --- Hero Slider Modern --- */
  .swiper {
    width: 100%;
    height: 100vh;
  }
  .swiper-slide {
    background-size: cover;
    background-position: center;
    position: relative;
  }
  .overlay-gradient {
    position: absolute;
    inset: 0;
    background: linear-gradient(180deg, rgba(0, 0, 0, 0.3) 0%, rgba(0, 50, 0, 0.7) 100%);
    z-index: 1;
  }
  .slide-content {
    position: relative;
    z-index: 2;
  }
  .swiper-pagination-bullet {
    background: #fff !important;
    opacity: 0.8;
  }
  .swiper-button-prev,
  .swiper-button-next {
    color: #fff;
  }

  /* --- Mobile tweaks --- */
  @media (max-width: 640px) {
    .swiper { height: 70vh; }
    .swiper-button-prev, .swiper-button-next { display: none; }
    .swiper-pagination-bullet { transform: scale(0.9); }
  }

  /* --- Kepala Desa Section --- */
  .kepala-desa-card {
    position: relative;
    overflow: hidden;
    border-radius: 1.5rem;
    background: #fff;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
    transition: transform 0.4s ease;
  }
  .kepala-desa-card:hover {
    transform: scale(1.03);
  }
  .kepala-desa-card::before {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(135deg, #00ff88 0%, #00b4d8 100%);
    opacity: 0.3;
    mix-blend-mode: overlay;
  }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- HERO SLIDER -->
<div class="swiper mySwiper">
  <div class="swiper-wrapper">
    <!-- Slide 1 -->
    <div class="swiper-slide" style="background-image: url('<?php echo e(asset('img/slide1.jpeg')); ?>')">
      <div class="overlay-gradient"></div>
      <div class="slide-content flex flex-col items-center justify-center h-full text-center text-white px-4 sm:px-6">
        <h1 class="text-3xl sm:text-4xl md:text-6xl font-extrabold mb-4 drop-shadow-lg">
          Selamat Datang di Pemerintahan Desa Baujeng
        </h1>
        <p class="text-base sm:text-lg md:text-xl mb-6 text-green-100 max-w-3xl">
          Mewujudkan Desa Baujeng yang Mandiri dan Sejahtera melalui inovasi dan pelayanan berbasis digital.
        </p>
        <a href="<?php echo e(url('profil')); ?>" class="bg-green-500 hover:bg-green-600 text-white font-semibold py-2 px-6 sm:py-3 sm:px-8 rounded-full shadow-lg transition duration-300">
          Lihat Profil
        </a>
      </div>
    </div>

    <!-- Slide 2 -->
    <div class="swiper-slide" style="background-image: url('<?php echo e(asset('img/slide2.jpg')); ?>')">
      <div class="overlay-gradient"></div>
      <div class="slide-content flex flex-col items-center justify-center h-full text-center text-white px-4 sm:px-6">
        <h1 class="text-3xl sm:text-4xl md:text-6xl font-extrabold mb-4">Pelayanan Cepat dan Transparan</h1>
        <p class="text-base sm:text-lg md:text-xl mb-6 text-green-100 max-w-3xl">
          Layanan publik berbasis sistem digital untuk efisiensi dan transparansi pemerintahan desa.
        </p>
        <a href="<?php echo e(route('tentang')); ?>" class="bg-blue-500 hover:bg-blue-600 text-white font-semibold py-2 px-6 sm:py-3 sm:px-8 rounded-full shadow-lg transition duration-300">
          Pelajari Lebih Lanjut
        </a>
      </div>
    </div>

    <!-- Slide 3 -->
    <div class="swiper-slide" style="background-image: url('<?php echo e(asset('img/slide3.webp')); ?>')">
      <div class="overlay-gradient"></div>
      <div class="slide-content flex flex-col items-center justify-center h-full text-center text-white px-4 sm:px-6">
        <h1 class="text-3xl sm:text-4xl md:text-6xl font-extrabold mb-4">Menuju Desa Digital</h1>
        <p class="text-base sm:text-lg md:text-xl mb-6 text-green-100 max-w-3xl">
          Transformasi digital untuk meningkatkan kemudahan akses informasi bagi seluruh warga Desa Baujeng.
        </p>
        <a href="<?php echo e(route('produk')); ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white font-semibold py-2 px-6 sm:py-3 sm:px-8 rounded-full shadow-lg transition duration-300">
          Lihat Program
        </a>
      </div>
    </div>
  </div>

  <!-- Navigasi -->
  <div class="swiper-pagination"></div>
  <div class="swiper-button-prev"></div>
  <div class="swiper-button-next"></div>
</div>

<?php if($profil && (
    $profil->luas_wilayah || 
    $profil->jumlah_dusun || 
    $profil->jumlah_rw || 
    $profil->jumlah_rt
)): ?>
<section class="bg-green-50 py-12">
  <div class="max-w-6xl mx-auto px-6 grid sm:grid-cols-2 lg:grid-cols-4 gap-6">
    <?php if($profil->luas_wilayah): ?>
    <div class="bg-white p-6 rounded-xl shadow hover:shadow-lg text-center transition">
      <div class="w-14 h-14 mx-auto mb-3 bg-green-100 rounded-full flex items-center justify-center">
        <i class="fas fa-map text-green-600 text-2xl"></i>
      </div>
      <h3 class="font-bold text-lg text-gray-800"><?php echo e(number_format($profil->luas_wilayah, 2)); ?> km²</h3>
      <p class="text-gray-600 text-sm">Luas Wilayah</p>
    </div>
    <?php endif; ?>

    <?php if($profil->jumlah_dusun): ?>
    <div class="bg-white p-6 rounded-xl shadow hover:shadow-lg text-center transition">
      <div class="w-14 h-14 mx-auto mb-3 bg-yellow-100 rounded-full flex items-center justify-center">
        <i class="fas fa-tree text-yellow-600 text-2xl"></i>
      </div>
      <h3 class="font-bold text-lg text-gray-800"><?php echo e($profil->jumlah_dusun); ?></h3>
      <p class="text-gray-600 text-sm">Jumlah Dusun</p>
    </div>
    <?php endif; ?>

    <?php if($profil->jumlah_rw): ?>
    <div class="bg-white p-6 rounded-xl shadow hover:shadow-lg text-center transition">
      <div class="w-14 h-14 mx-auto mb-3 bg-pink-100 rounded-full flex items-center justify-center">
        <i class="fas fa-layer-group text-pink-600 text-2xl"></i>
      </div>
      <h3 class="font-bold text-lg text-gray-800"><?php echo e($profil->jumlah_rw); ?></h3>
      <p class="text-gray-600 text-sm">Jumlah RW</p>
    </div>
    <?php endif; ?>

    <?php if($profil->jumlah_rt): ?>
    <div class="bg-white p-6 rounded-xl shadow hover:shadow-lg text-center transition">
      <div class="w-14 h-14 mx-auto mb-3 bg-red-100 rounded-full flex items-center justify-center">
        <i class="fas fa-users-cog text-red-600 text-2xl"></i>
      </div>
      <h3 class="font-bold text-lg text-gray-800"><?php echo e($profil->jumlah_rt); ?></h3>
      <p class="text-gray-600 text-sm">Jumlah RT</p>
    </div>
    <?php endif; ?>
  </div>
</section>
<?php endif; ?>

<!-- INFORMASI KEPALA DESA -->
<section class="relative overflow-hidden bg-gradient-to-br from-emerald-900 via-emerald-800 to-teal-700 text-white py-20">
  <!-- Ornamen Latar -->
  <div class="absolute inset-0">
    <div class="absolute top-10 -left-20 w-96 h-96 bg-lime-400/20 rounded-full blur-3xl"></div>
    <div class="absolute bottom-0 right-0 w-[32rem] h-[32rem] bg-teal-400/30 rounded-full blur-3xl"></div>
    <div class="absolute inset-0 bg-[url('<?php echo e(asset('img/pattern.svg')); ?>')] opacity-10 bg-cover bg-center"></div>
  </div>

  <div class="relative z-10 max-w-7xl mx-auto px-6 grid grid-cols-1 md:grid-cols-2 gap-8 md:gap-16 items-center">
    
    <!-- Kolom Kiri: Foto Kepala Desa -->
    <div class="flex justify-center">
      <div class="relative group">
        <!-- Bingkai bercahaya -->
        <div class="absolute -inset-4 rounded-3xl bg-gradient-to-tr from-lime-400 to-teal-300 opacity-60 blur-xl group-hover:opacity-80 transition"></div>
        
        <!-- Kartu foto bergaya glass -->
        <div class="relative backdrop-blur-xl bg-white/10 border border-white/20 rounded-3xl overflow-hidden shadow-2xl transition-transform duration-500 group-hover:scale-105">
          <?php if($profil && $profil->foto_kepala_desa): ?>
            <img src="<?php echo e(asset('storage/'.$profil->foto_kepala_desa)); ?>" alt="Kepala Desa" class="w-56 h-[320px] md:w-80 md:h-[440px] object-cover rounded-3xl">
          <?php else: ?>
            <img src="<?php echo e(asset('img/desa.jpg')); ?>" alt="Kepala Desa" class="w-56 h-[320px] md:w-80 md:h-[440px] object-cover rounded-3xl">
          <?php endif; ?>
        </div>

        <!-- Nama Kepala Desa -->
        <div class="text-center mt-6">
          <h3 class="text-2xl font-bold text-white tracking-wide drop-shadow-lg"><?php echo e(($profil && $profil->kepala_desa) ? $profil->kepala_desa : 'Kepala Desa'); ?></h3>
          <p class="text-lime-300 font-semibold tracking-wide"><?php echo e(($profil && $profil->nama_desa) ? 'Kepala Desa '.$profil->nama_desa : 'Kepala Desa Baujeng'); ?></p>
        </div>
      </div>
    </div>

    <!-- Kolom Kanan: Sambutan -->
    <div class="text-center md:text-left space-y-6">
      <h1 class="text-3xl sm:text-4xl md:text-5xl font-extrabold leading-tight">
        <span class="text-lime-300">Selamat Datang</span><br>
        di Pemerintahan Desa Baujeng
      </h1>
      <p class="text-base sm:text-lg text-emerald-100 max-w-lg leading-relaxed whitespace-pre-line">
        <?php echo e(($profil && $profil->sambutan_kepala_desa) ? $profil->sambutan_kepala_desa : 'Kami berkomitmen untuk membangun tata kelola desa yang modern, inklusif, dan berdaya teknologi. Dengan semangat gotong royong, kami hadir memberikan pelayanan terbaik bagi masyarakat.'); ?>

      </p>
      <a href="<?php echo e(url('profil')); ?>" 
         class="inline-block bg-lime-400 text-emerald-900 font-semibold px-6 py-2 sm:px-8 sm:py-3 rounded-full shadow-lg hover:bg-lime-300 hover:scale-105 transition-all duration-300">
        Lihat Profil Desa
      </a>
    </div>
  </div>
</section>

<!-- TRANSPARANSI DANA DESA -->
<section id="transparansi" class="py-12 md:py-20 bg-gradient-to-b from-white to-green-50">
  <div class="max-w-6xl mx-auto px-6">
    <h2 class="text-3xl md:text-4xl font-extrabold text-emerald-800 text-center mb-8 md:mb-12">
      Transparansi Dana Desa Tahun <?php echo e(date('Y')); ?>

    </h2>

    <div class="bg-white rounded-2xl shadow-xl p-6 md:p-8 border border-green-100">
      <?php
        $colors = ['emerald', 'lime', 'sky', 'amber', 'rose'];
        if (isset($anggaranItems) && $anggaranItems->count() > 0) {
          $anggaran = $anggaranItems->map(function($i, $idx) use ($colors) {
            return [
              'nama' => $i->kategori,
              'nilai' => (float) $i->jumlah,
              'warna' => $colors[$idx % count($colors)],
            ];
          })->toArray();
          $total = (float) ($totalAnggaran ?? array_sum(array_column($anggaran, 'nilai')));
        } else {
          $anggaran = [];
          $total = 0;
        }
      ?>

      <div class="space-y-6 md:space-y-8">
        <?php $__currentLoopData = $anggaran; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          $persentase = ($item['nilai'] / $total) * 100;
        ?>
        <div>
          <div class="flex justify-between items-center mb-2 gap-3">
            <h3 class="text-gray-800 font-semibold text-base sm:text-lg"><?php echo e($item['nama']); ?></h3>
            <p class="font-bold text-emerald-700">Rp <?php echo e(number_format($item['nilai'], 0, ',', '.')); ?></p>
          </div>
          <div class="w-full bg-gray-200 rounded-full h-3 md:h-4 overflow-hidden">
            <div class="progress-bar h-3 md:h-4 rounded-full bg-<?php echo e($item['warna']); ?>-500 transition-all duration-1000 ease-out"
                 data-width="<?php echo e($persentase); ?>%" style="width: 0%"></div>
          </div>
          <p class="text-sm text-gray-500 mt-1"><?php echo e(number_format($persentase, 2)); ?>%</p>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>

      <div class="border-t border-dashed border-green-300 mt-10 pt-6 text-center">
        <h3 class="text-2xl font-bold text-emerald-900">
          Total Belanja Desa: Rp <?php echo e(number_format($total, 0, ',', '.')); ?>

        </h3>
      </div>
    </div>
  </div>
</section>

<?php if(isset($latestBerita) && $latestBerita->count() > 0): ?>
<section class="py-16 bg-white">
  <div class="max-w-6xl mx-auto px-6">
    <div class="flex items-center justify-between mb-8">
      <h2 class="text-3xl md:text-4xl font-extrabold text-emerald-800">Berita Terbaru</h2>
      <a href="<?php echo e(route('berita')); ?>" class="text-emerald-700 hover:text-emerald-900 font-semibold">Lihat Semua</a>
    </div>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
      <?php $__currentLoopData = $latestBerita; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <article class="bg-white rounded-xl shadow hover:shadow-lg transition overflow-hidden">
        <a href="<?php echo e(route('berita.detail', $b->slug)); ?>" class="block">
          <?php
            $img = $b->gambar ? asset('storage/'.$b->gambar) : asset('img/slide2.jpg');
          ?>
          <img src="<?php echo e($img); ?>" alt="<?php echo e($b->judul); ?>" class="w-full h-48 sm:h-40 object-cover">
        </a>
        <div class="p-3 sm:p-4">
          <h3 class="font-bold text-gray-800 line-clamp-2 text-base sm:text-lg">
            <a href="<?php echo e(route('berita.detail', $b->slug)); ?>"><?php echo e($b->judul); ?></a>
          </h3>
          <p class="text-sm text-gray-600 mt-2 line-clamp-3"><?php echo e($b->excerpt); ?></p>
          <div class="mt-4 flex items-center justify-between text-xs text-gray-500">
            <span><?php echo e($b->published_at ? $b->published_at->format('d M Y') : '-'); ?></span>
            <a href="<?php echo e(route('berita.detail', $b->slug)); ?>" class="text-emerald-700 hover:text-emerald-900 font-semibold">Baca</a>
          </div>
        </div>
      </article>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</section>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
<script>
  // Inisialisasi Swiper
  const swiper = new Swiper(".mySwiper", {
    loop: true,
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
    },
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    effect: "fade",
    fadeEffect: { crossFade: true },
    speed: 1000,
  });

  // Animasi progress bar
  (function initProgressBars(){
    const run = () => {
      const bars = document.querySelectorAll('.progress-bar');
      if (!bars.length) return;

      const observer = new IntersectionObserver(entries => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            const bar = entry.target;
            const targetWidth = bar.getAttribute('data-width');
            bar.style.width = targetWidth;
            bar.style.opacity = 1;
            observer.unobserve(bar);
          }
        });
      }, { threshold: 0.3 });

      bars.forEach(bar => {
        bar.style.width = "0%";
        bar.style.opacity = 0;
        observer.observe(bar);
      });
    };
    if (document.readyState === 'loading') {
      document.addEventListener('DOMContentLoaded', run);
    } else {
      run();
    }
  })();
</script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_class', 'flex-1 w-full px-0'); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/index.blade.php ENDPATH**/ ?>