<?php $__env->startSection('title', 'Staf Desa'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>Staf / Aparat Desa</h2>
        <a href="<?php echo e(route('admin.staf.create')); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> Tambah Staf</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-body">
            <div class="row">
                <?php $__empty_1 = true; $__currentLoopData = $staf; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-md-3 mb-4">
                        <div class="card h-100">
                            <?php if(!empty($item['foto'])): ?>
                                <img src="<?php echo e(asset('storage/' . $item['foto'])); ?>" class="card-img-top" style="height:180px;object-fit:cover;">
                            <?php else: ?>
                                <div class="d-flex align-items-center justify-content-center" style="height:180px;background:#f1f1f1;">
                                    <i class="fa fa-user fa-3x text-secondary"></i>
                                </div>
                            <?php endif; ?>
                            <div class="card-body">
                                <h5 class="card-title mb-1"><?php echo e($item['nama']); ?></h5>
                                <p class="card-text text-muted"><?php echo e($item['jabatan']); ?></p>
                                <div class="d-flex gap-2">
                                    <a href="<?php echo e(route('admin.staf.edit', $i)); ?>" class="btn btn-sm btn-warning"><i class="fa fa-edit"></i> Edit</a>
                                    <form action="<?php echo e(route('admin.staf.destroy', $i)); ?>" method="POST" onsubmit="return confirm('Hapus staf ini?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i> Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12">
                        <div class="alert alert-info">Belum ada data staf tambahan.</div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/admin/staf/index.blade.php ENDPATH**/ ?>