<?php $__env->startSection('title', 'Lowongan Kerja Desa Baujeng'); ?>

<?php $__env->startSection('main_class', 'flex-1 w-full px-0'); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="relative bg-green-700 text-white py-12 sm:py-20 shadow-xl">
  <div class="max-w-6xl mx-auto px-6 text-center">
    <h1 class="text-3xl sm:text-4xl md:text-5xl font-extrabold mb-4">Lowongan Kerja Desa Baujeng</h1>
    <p class="text-base sm:text-lg md:text-xl opacity-90 max-w-2xl mx-auto">
      Temukan peluang karir terbaik di sekitar Desa Baujeng dan bergabunglah dengan perusahaan-perusahaan terpercaya
    </p>
  </div>
  <div class="absolute bottom-0 left-0 right-0">
    <svg class="w-full h-10 sm:h-16 text-white" viewBox="0 0 1440 320" preserveAspectRatio="none" fill="currentColor">
      <path d="M0,160L48,170.7C96,181,192,203,288,218.7C384,235,480,245,576,245.3C672,245,768,235,864,224C960,213,1056,203,1152,181.3C1248,160,1344,128,1392,112L1440,96L1440,320L0,320Z"></path>
    </svg>
  </div>
</section>

<!-- Job Listings -->
<section class="max-w-7xl mx-auto px-6 py-12 sm:py-16">
  <?php if($lowongan->count() > 0): ?>
    <div class="space-y-6">
      <?php $__currentLoopData = $lowongan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="bg-white rounded-2xl shadow-lg p-4 sm:p-6 hover:shadow-xl transition-shadow border border-gray-100">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4 sm:gap-6">
          <!-- Job Info -->
          <div class="flex-1">
            <div class="flex items-center gap-3 mb-3">
              <span class="bg-green-100 text-green-700 px-3 py-1 rounded-full text-sm font-medium">
                <?php echo e($item->jenis_pekerjaan ?? 'Full Time'); ?>

              </span>
              <?php
                $isExpiringSoon = $item->batas_lamaran && $item->batas_lamaran->diffInDays(now()) <= 7;
                $isExpired = $item->batas_lamaran && $item->batas_lamaran < now();
              ?>
              <?php if($isExpired): ?>
              <span class="bg-red-100 text-red-700 px-3 py-1 rounded-full text-sm font-medium">
                Expired
              </span>
              <?php elseif($isExpiringSoon): ?>
              <span class="bg-yellow-100 text-yellow-700 px-3 py-1 rounded-full text-sm font-medium">
                Segera Berakhir
              </span>
              <?php else: ?>
              <span class="bg-green-100 text-green-700 px-3 py-1 rounded-full text-sm font-medium">
                Aktif
              </span>
              <?php endif; ?>
            </div>
            
            <h3 class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-800 mb-2">
              <a href="<?php echo e(route('lowongan.detail', $item->id)); ?>" class="hover:text-orange-600 transition-colors">
                <?php echo e($item->posisi); ?>

              </a>
            </h3>
            
            <div class="flex flex-wrap items-center gap-3 sm:gap-4 text-gray-600 mb-3">
              <div class="flex items-center">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-4m-5 0H3m2 0h4M9 7h6m-6 4h6m-6 4h6"></path>
                </svg>
                <?php echo e($item->perusahaan); ?>

              </div>
              
              <?php if($item->lokasi): ?>
              <div class="flex items-center">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                </svg>
                <?php echo e($item->lokasi); ?>

              </div>
              <?php endif; ?>
              
              <?php if($item->gaji_min || $item->gaji_max): ?>
              <div class="flex items-center">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                </svg>
                <?php if($item->gaji_min && $item->gaji_max): ?>
                  Rp <?php echo e(number_format($item->gaji_min, 0, ',', '.')); ?> - Rp <?php echo e(number_format($item->gaji_max, 0, ',', '.')); ?>

                <?php elseif($item->gaji_min): ?>
                  Minimal Rp <?php echo e(number_format($item->gaji_min, 0, ',', '.')); ?>

                <?php else: ?>
                  Maksimal Rp <?php echo e(number_format($item->gaji_max, 0, ',', '.')); ?>

                <?php endif; ?>
              </div>
              <?php endif; ?>
            </div>
            
            <p class="text-gray-600 line-clamp-2">
              <?php echo e(Str::limit(strip_tags($item->deskripsi), 150)); ?>

            </p>
          </div>
          
          <!-- Job Actions -->
          <div class="flex flex-col items-end gap-2 sm:gap-3">
            <?php if($item->batas_lamaran): ?>
            <div class="text-sm text-gray-500 text-right">
              <span class="block">Batas Lamaran:</span>
              <span class="font-medium <?php echo e($isExpiringSoon ? 'text-yellow-600' : ($isExpired ? 'text-red-600' : 'text-gray-700')); ?>">
                <?php echo e($item->batas_lamaran->format('d M Y')); ?>

              </span>
            </div>
            <?php endif; ?>
            
            <a href="<?php echo e(route('lowongan.detail', $item->id)); ?>" 
               class="inline-flex items-center px-4 py-2 text-sm sm:px-6 sm:py-3 sm:text-base bg-green-600 text-white rounded-lg hover:bg-orange-700 transition-colors font-medium">
              Lihat Detail
              <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Pagination -->
    <div class="mt-12">
      <?php echo e($lowongan->links()); ?>

    </div>
  <?php else: ?>
    <!-- Empty State -->
    <div class="text-center py-16">
      <div class="w-32 h-32 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
        <span class="text-4xl text-gray-400">💼</span>
      </div>
      <h3 class="text-2xl font-bold text-gray-800 mb-4">Belum Ada Lowongan</h3>
      <p class="text-gray-600 max-w-md mx-auto">
        Saat ini belum ada lowongan kerja yang tersedia. Silakan kembali lagi nanti untuk melihat peluang karir terbaru.
      </p>
    </div>
  <?php endif; ?>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.line-clamp-2 {
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/lowongan/index.blade.php ENDPATH**/ ?>