<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard Utama'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
  <!-- Statistik Ringkas -->
  <div class="row mb-4">
    <div class="col-md-3 mb-3">
      <div class="card text-center shadow-sm border-0 bg-primary text-white">
        <div class="card-body">
          <i class="fas fa-users fa-2x mb-2"></i>
          <h6 class="fw-bold mb-1">Jumlah Warga</h6>
          <h4><?php echo e($jumlahWarga ?? 0); ?></h4>
        </div>
      </div>
    </div>
    <div class="col-md-3 mb-3">
      <div class="card text-center shadow-sm border-0 bg-success text-white">
        <div class="card-body">
          <i class="fas fa-money-bill-wave fa-2x mb-2"></i>
          <h6 class="fw-bold mb-1">Total Anggaran</h6>
          <h4>Rp <?php echo e(number_format($totalAnggaran ?? 0, 0, ',', '.')); ?></h4>
        </div>
      </div>
    </div>
    <div class="col-md-3 mb-3">
      <div class="card text-center shadow-sm border-0 bg-warning text-dark">
        <div class="card-body">
          <i class="fas fa-newspaper fa-2x mb-2"></i>
          <h6 class="fw-bold mb-1">Jumlah Berita</h6>
          <h4><?php echo e($jumlahBerita ?? 0); ?></h4>
        </div>
      </div>
    </div>
    <div class="col-md-3 mb-3">
      <div class="card text-center shadow-sm border-0 bg-danger text-white">
        <div class="card-body">
          <i class="fas fa-box fa-2x mb-2"></i>
          <h6 class="fw-bold mb-1">Jumlah Produk</h6>
          <h4><?php echo e($jumlahProduk ?? 0); ?></h4>
        </div>
      </div>
    </div>
  </div>

  <!-- Aksi Cepat -->
  <div class="card shadow-sm border-0 mb-4">
    <div class="card-header bg-light fw-bold">
      <i class="fas fa-bolt"></i> Aksi Cepat
    </div>
    <div class="card-body">
      <div class="d-flex flex-wrap gap-2">
        <a href="<?php echo e(route('admin.berita.create')); ?>" class="btn btn-primary">
          <i class="fas fa-plus"></i> Tambah Berita
        </a>
        <a href="<?php echo e(route('admin.anggaran.create')); ?>" class="btn btn-success">
          <i class="fas fa-plus"></i> Tambah Anggaran
        </a>
        <a href="<?php echo e(route('admin.produk.create')); ?>" class="btn btn-warning text-dark">
          <i class="fas fa-plus"></i> Tambah Produk
        </a>
      </div>
    </div>
  </div>

  <!-- Daftar Terbaru -->
  <div class="row">
    <div class="col-md-6 mb-4">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-light fw-bold">
          <i class="fas fa-newspaper"></i> Berita Terbaru
        </div>
        <div class="card-body">
          <?php if(!empty($beritaTerbaru) && count($beritaTerbaru)): ?>
            <ul class="list-group list-group-flush">
              <?php $__currentLoopData = $beritaTerbaru; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                  <div>
                    <strong><?php echo e($b->judul); ?></strong><br>
                    <small class="text-muted"><?php echo e($b->created_at->format('d M Y')); ?></small>
                  </div>
                  <a href="<?php echo e(route('admin.berita.edit', $b->id)); ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          <?php else: ?>
            <p class="text-muted text-center">Belum ada berita terbaru.</p>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="col-md-6 mb-4">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-light fw-bold">
          <i class="fas fa-box"></i> Produk Terbaru
        </div>
        <div class="card-body">
          <?php if(!empty($produkTerbaru) && count($produkTerbaru)): ?>
            <ul class="list-group list-group-flush">
              <?php $__currentLoopData = $produkTerbaru; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                  <div>
                    <strong><?php echo e($p->nama); ?></strong><br>
                    <small class="text-muted"><?php echo e($p->created_at->format('d M Y')); ?></small>
                  </div>
                  <a href="<?php echo e(route('admin.produk.edit', $p->id)); ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          <?php else: ?>
            <p class="text-muted text-center">Belum ada produk terbaru.</p>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>