<?php $__env->startSection('title', 'Detail Produk'); ?>
<?php $__env->startSection('page-title', 'Detail Produk'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <!-- Main Content -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-box"></i> <?php echo e($produk->nama); ?></h5>
                <span class="badge bg-<?php echo e($produk->status == 'aktif' ? 'success' : 'secondary'); ?> fs-6">
                    <?php echo e(ucfirst($produk->status)); ?>

                </span>
            </div>
            <div class="card-body">
                <!-- Gambar Produk -->
                <?php
                    $img = $produk->gambar;
                    if (is_array($img)) {
                        $img = $img[0] ?? null;
                    }
                ?>
                <?php if(!empty($img)): ?>
                    <div class="text-center mb-4">
                        <img src="<?php echo e(asset('storage/' . $img)); ?>" 
                             alt="<?php echo e($produk->nama); ?>" 
                             class="img-fluid rounded shadow"
                             style="max-height: 400px; object-fit: cover;">
                    </div>
                <?php else: ?>
                    <div class="text-center mb-4">
                        <div class="bg-light d-flex align-items-center justify-content-center rounded" 
                             style="height: 300px;">
                            <div class="text-muted">
                                <i class="fas fa-image fa-3x mb-2"></i>
                                <p>Tidak ada gambar</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Informasi Harga dan Stok -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center">
                                <h3 class="mb-0">Rp <?php echo e(number_format($produk->harga, 0, ',', '.')); ?></h3>
                                <small>Harga Produk</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-<?php echo e($produk->stok > 10 ? 'primary' : ($produk->stok > 0 ? 'warning' : 'danger')); ?> text-white">
                            <div class="card-body text-center">
                                <h3 class="mb-0"><?php echo e($produk->stok); ?></h3>
                                <small>Stok Tersedia</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Deskripsi -->
                <?php if($produk->deskripsi): ?>
                    <div class="mb-4">
                        <h6><i class="fas fa-align-left"></i> Deskripsi Singkat</h6>
                        <p class="text-muted"><?php echo e($produk->deskripsi); ?></p>
                    </div>
                <?php endif; ?>

                <!-- Detail -->
                <?php if($produk->detail): ?>
                    <div class="mb-4">
                        <h6><i class="fas fa-list-ul"></i> Detail Produk</h6>
                        <div class="bg-light p-3 rounded">
                            <?php echo nl2br(e($produk->detail)); ?>

                        </div>
                    </div>
                <?php endif; ?>

                <!-- Kontak Penjual -->
                <?php if($produk->penjual || $produk->kontak_penjual): ?>
                    <div class="mb-4">
                        <h6><i class="fas fa-phone"></i> Kontak Penjual</h6>
                        <div class="row">
                            <?php if($produk->penjual): ?>
                                <div class="col-md-6">
                                    <strong>Nama:</strong> <?php echo e($produk->penjual); ?>

                                </div>
                            <?php endif; ?>
                            <?php if($produk->kontak_penjual): ?>
                                <div class="col-md-6">
                                    <strong>HP/WhatsApp:</strong> 
                                    <a href="https://wa.me/<?php echo e(preg_replace('/[^0-9]/', '', $produk->kontak_penjual)); ?>" 
                                       target="_blank" class="text-success">
                                        <?php echo e($produk->kontak_penjual); ?> <i class="fab fa-whatsapp"></i>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Quick Actions -->
                <div class="d-flex gap-2 flex-wrap">
                    <?php if($produk->status == 'nonaktif'): ?>
                        <form action="<?php echo e(route('admin.produk.update', $produk->id)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="hidden" name="status" value="aktif">
                            <input type="hidden" name="nama" value="<?php echo e($produk->nama); ?>">
                            <input type="hidden" name="harga" value="<?php echo e($produk->harga); ?>">
                            <input type="hidden" name="stok" value="<?php echo e($produk->stok); ?>">
                            <button type="submit" class="btn btn-success btn-sm">
                                <i class="fas fa-check"></i> Aktifkan
                            </button>
                        </form>
                    <?php else: ?>
                        <form action="<?php echo e(route('admin.produk.update', $produk->id)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="hidden" name="status" value="nonaktif">
                            <input type="hidden" name="nama" value="<?php echo e($produk->nama); ?>">
                            <input type="hidden" name="harga" value="<?php echo e($produk->harga); ?>">
                            <input type="hidden" name="stok" value="<?php echo e($produk->stok); ?>">
                            <button type="submit" class="btn btn-warning btn-sm">
                                <i class="fas fa-pause"></i> Nonaktifkan
                            </button>
                        </form>
                    <?php endif; ?>
                    
                    <button type="button" class="btn btn-info btn-sm" onclick="copyLink()">
                        <i class="fas fa-link"></i> Salin Link
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar Info -->
    <div class="col-lg-4">
        <!-- Info Panel -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-info-circle"></i> Informasi Produk</h6>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr>
                        <td><strong>ID:</strong></td>
                        <td><?php echo e($produk->id); ?></td>
                    </tr>
                    <?php if($produk->kategori): ?>
                        <tr>
                            <td><strong>Kategori:</strong></td>
                            <td>
                                <span class="badge bg-secondary"><?php echo e(ucfirst($produk->kategori)); ?></span>
                            </td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <td><strong>Status:</strong></td>
                        <td>
                            <span class="badge bg-<?php echo e($produk->status == 'aktif' ? 'success' : 'secondary'); ?>">
                                <?php echo e(ucfirst($produk->status)); ?>

                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Dibuat:</strong></td>
                        <td><?php echo e($produk->created_at->format('d M Y H:i')); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Diupdate:</strong></td>
                        <td><?php echo e($produk->updated_at->format('d M Y H:i')); ?></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Actions -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-cogs"></i> Aksi</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('admin.produk.edit', $produk->id)); ?>" class="btn btn-warning">
                        <i class="fas fa-edit"></i> Edit Produk
                    </a>
                    
                    <a href="<?php echo e(route('produk')); ?>#produk-<?php echo e($produk->id); ?>" 
                       target="_blank" class="btn btn-info">
                        <i class="fas fa-external-link-alt"></i> Lihat di Website
                    </a>
                    
                    <form action="<?php echo e(route('admin.produk.destroy', $produk->id)); ?>" 
                          method="POST" 
                          onsubmit="return confirm('Yakin ingin menghapus produk ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Hapus Produk
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- SEO Info -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-search"></i> Informasi SEO</h6>
            </div>
            <div class="card-body">
                <small class="text-muted">
                    <strong>URL:</strong><br>
                    <code><?php echo e(url('/produk#produk-' . $produk->id)); ?></code>
                </small>
                
                <?php if($produk->deskripsi): ?>
                    <hr>
                    <small class="text-muted">
                        <strong>Meta Description:</strong><br>
                        <?php echo e(Str::limit($produk->deskripsi, 160)); ?>

                    </small>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Navigation -->
<div class="row mt-4">
    <div class="col-12">
        <div class="d-flex justify-content-between">
            <a href="<?php echo e(route('admin.produk.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali ke Daftar
            </a>
            
            <div>
                <?php
                    $prevProduk = \App\Models\Produk::where('id', '<', $produk->id)->orderBy('id', 'desc')->first();
                    $nextProduk = \App\Models\Produk::where('id', '>', $produk->id)->orderBy('id', 'asc')->first();
                ?>
                
                <?php if($prevProduk): ?>
                    <a href="<?php echo e(route('admin.produk.show', $prevProduk->id)); ?>" 
                       class="btn btn-outline-secondary me-2" title="Produk Sebelumnya">
                        <i class="fas fa-chevron-left"></i> <?php echo e(Str::limit($prevProduk->nama, 20)); ?>

                    </a>
                <?php endif; ?>
                
                <?php if($nextProduk): ?>
                    <a href="<?php echo e(route('admin.produk.show', $nextProduk->id)); ?>" 
                       class="btn btn-outline-secondary" title="Produk Selanjutnya">
                        <?php echo e(Str::limit($nextProduk->nama, 20)); ?> <i class="fas fa-chevron-right"></i>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function copyLink() {
    const url = "<?php echo e(url('/produk#produk-' . $produk->id)); ?>";
    navigator.clipboard.writeText(url).then(function() {
        // Show success message
        const btn = event.target.closest('button');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i> Tersalin!';
        btn.classList.remove('btn-info');
        btn.classList.add('btn-success');
        
        setTimeout(function() {
            btn.innerHTML = originalText;
            btn.classList.remove('btn-success');
            btn.classList.add('btn-info');
        }, 2000);
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/admin/produk/show.blade.php ENDPATH**/ ?>