<?php $__env->startSection('title', 'Detail Data Demografi'); ?>
<?php $__env->startSection('page-title', 'Detail Data Demografi'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <!-- Main Content -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-chart-bar"></i> <?php echo e($demografi->label); ?></h5>
                    <span class="badge bg-info fs-6">
                        <?php echo e($demografi->tahun ?? 'N/A'); ?>

                    </span>
                </div>
            </div>
            <div class="card-body">
                <!-- Nilai Utama -->
                <div class="text-center mb-4">
                    <div class="display-4 text-primary fw-bold">
                        <?php echo e(number_format($demografi->jumlah, 0, ',', '.')); ?>

                    </div>
                    <p class="text-muted mb-0"><?php echo e($demografi->label); ?></p>
                </div>

                <!-- Kategori -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-tag text-info me-2"></i>
                            <span class="fw-bold me-2">Kategori:</span>
                            <span class="badge bg-info"><?php echo e(ucfirst($demografi->kategori)); ?></span>
                        </div>
                    </div>
                </div>

                <!-- Keterangan -->
                <?php if($demografi->keterangan): ?>
                <div class="mb-4">
                    <h6><i class="fas fa-info-circle text-info"></i> Keterangan</h6>
                    <div class="bg-light p-3 rounded">
                        <?php echo e($demografi->keterangan); ?>

                    </div>
                </div>
                <?php endif; ?>

                <!-- Tahun Data -->
                <?php if($demografi->tahun): ?>
                <div class="mb-4">
                    <h6><i class="fas fa-calendar text-warning"></i> Tahun Data</h6>
                    <p class="mb-0"><?php echo e($demografi->tahun); ?></p>
                </div>
                <?php endif; ?>

                <!-- Quick Actions -->
                <div class="d-flex gap-2 flex-wrap">
                    <button class="btn btn-outline-info btn-sm" onclick="copyData()">
                        <i class="fas fa-copy"></i> Salin Data
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Info Panel -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-info"></i> Info Panel</h6>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless">
                    <tr>
                        <td><strong>ID:</strong></td>
                        <td><?php echo e($demografi->id); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Kategori:</strong></td>
                        <td><span class="badge bg-info"><?php echo e(ucfirst($demografi->kategori)); ?></span></td>
                    </tr>
                    <tr>
                        <td><strong>Jumlah:</strong></td>
                        <td>
                            <strong><?php echo e(number_format($demografi->jumlah, 0, ',', '.')); ?></strong>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Keterangan:</strong></td>
                        <td><?php echo e($demografi->keterangan ?? 'Tidak ada keterangan'); ?></td>
                    </tr>
                    <?php if($demografi->tahun): ?>
                    <tr>
                        <td><strong>Tahun:</strong></td>
                        <td><?php echo e($demografi->tahun); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td><strong>Dibuat:</strong></td>
                        <td><?php echo e($demografi->created_at->format('d/m/Y H:i')); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Diupdate:</strong></td>
                        <td><?php echo e($demografi->updated_at->format('d/m/Y H:i')); ?></td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-cogs"></i> Aksi</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('admin.demografi.edit', $demografi->id)); ?>" class="btn btn-warning">
                        <i class="fas fa-edit"></i> Edit Data
                    </a>
                    
                    <button class="btn btn-danger" onclick="confirmDelete()">
                        <i class="fas fa-trash"></i> Hapus Data
                    </button>
                    
                    <hr>
                    
                    <a href="<?php echo e(route('admin.demografi.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Kembali ke Daftar
                    </a>
                </div>
            </div>
        </div>

        <!-- Data Comparison -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-chart-line"></i> Perbandingan Data</h6>
            </div>
            <div class="card-body">
                <p class="text-muted small">Fitur perbandingan dengan data serupa akan tersedia segera.</p>
                
                <!-- Placeholder for future comparison feature -->
                <div class="bg-light p-3 rounded text-center">
                    <i class="fas fa-chart-bar fa-2x text-muted mb-2"></i>
                    <p class="text-muted small mb-0">Grafik perbandingan data kategori <?php echo e($demografi->kategori); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Navigation -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        
                        <button class="btn btn-outline-secondary btn-sm" disabled>
                            <i class="fas fa-chevron-left"></i> Data Sebelumnya
                        </button>
                    </div>
                    
                    <div>
                        <a href="<?php echo e(route('admin.demografi.index')); ?>" class="btn btn-primary">
                            <i class="fas fa-list"></i> Semua Data Demografi
                        </a>
                    </div>
                    
                    <div>
                        
                        <button class="btn btn-outline-secondary btn-sm" disabled>
                            Data Selanjutnya <i class="fas fa-chevron-right"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden form for update -->
<form id="updateForm" action="<?php echo e(route('admin.demografi.update', $demografi->id)); ?>" method="POST" style="display: none;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
    <input type="hidden" name="kategori" value="<?php echo e($demografi->kategori); ?>">
    <input type="hidden" name="label" value="<?php echo e($demografi->label); ?>">
    <input type="hidden" name="jumlah" value="<?php echo e($demografi->jumlah); ?>">
    <input type="hidden" name="keterangan" value="<?php echo e($demografi->keterangan); ?>">
    <input type="hidden" name="tahun" value="<?php echo e($demografi->tahun); ?>">
</form>

<!-- Hidden form for delete -->
<form id="deleteForm" action="<?php echo e(route('admin.demografi.destroy', $demografi->id)); ?>" method="POST" style="display: none;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>
</form>

<script>
function confirmDelete() {
    if (confirm('Apakah Anda yakin ingin menghapus data demografi ini?\n\nData: <?php echo e($demografi->label); ?>\nJumlah: <?php echo e(number_format($demografi->jumlah, 0, ",", ".")); ?>\n\nTindakan ini tidak dapat dibatalkan!')) {
        document.getElementById('deleteForm').submit();
    }
}

function copyData() {
    const dataText = `Data Demografi: <?php echo e($demografi->label); ?>

Kategori: <?php echo e(ucfirst($demografi->kategori)); ?>

Jumlah: <?php echo e(number_format($demografi->jumlah, 0, ",", ".")); ?>

<?php if($demografi->tahun): ?>Tahun: <?php echo e($demografi->tahun); ?><?php endif; ?>
<?php if($demografi->keterangan): ?>Keterangan: <?php echo e($demografi->keterangan); ?><?php endif; ?>`;

    navigator.clipboard.writeText(dataText).then(function() {
        alert('Data berhasil disalin ke clipboard!');
    }, function(err) {
        console.error('Gagal menyalin data: ', err);
        alert('Gagal menyalin data ke clipboard.');
    });
}

// Auto-refresh data if needed (can be implemented later)
document.addEventListener('DOMContentLoaded', function() {
    // Future: Add real-time data updates if needed
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/admin/demografi/show.blade.php ENDPATH**/ ?>