<?php $__env->startSection('title', 'Manajemen Lowongan'); ?>
<?php $__env->startSection('page-icon', '<i class="fas fa-briefcase text-warning me-2"></i>'); ?>
<?php $__env->startSection('page-title', 'Manajemen Lowongan'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-briefcase"></i> Daftar Lowongan Kerja</h5>
                <a href="<?php echo e(route('admin.lowongan.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Lowongan
                </a>
            </div>
            <div class="card-body">
                <?php if($lowongan->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="25%">Posisi</th>
                                    <th width="20%">Perusahaan</th>
                                    <th width="15%">Lokasi</th>
                                    <th width="10%">Gaji</th>
                                    <th width="10%">Status</th>
                                    <th width="10%">Deadline</th>
                                    <th width="5%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $lowongan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($lowongan->firstItem() + $index); ?></td>
                                        <td>
                                            <h6 class="mb-1"><?php echo e(Str::limit($item->posisi, 30)); ?></h6>
                                            <small class="text-muted"><?php echo e(Str::limit($item->deskripsi, 50)); ?></small>
                                        </td>
                                        <td>
                                            <strong><?php echo e($item->perusahaan); ?></strong>
                                            <?php if($item->kontak_email): ?>
                                                <br><small class="text-muted"><?php echo e($item->kontak_email); ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->lokasi); ?></td>
                                        <td>
                                            <small class="text-success fw-bold">
                                                <?php echo e($item->gaji_min ? 'Rp ' . number_format($item->gaji_min, 0, ',', '.') : 'Nego'); ?>

                                                <?php echo e($item->gaji_max ? ' - ' . number_format($item->gaji_max, 0, ',', '.') : ($item->gaji_min ? '+' : '')); ?>

                                            </small>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?php echo e($item->status == 'aktif' ? 'success' : 'secondary'); ?>">
                                                <?php echo e(ucfirst($item->status)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <small class="text-muted">
                                                <?php echo e($item->deadline ? $item->deadline->format('d M Y') : '-'); ?>

                                            </small>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('admin.lowongan.show', $item->id)); ?>" 
                                                   class="btn btn-sm btn-info" title="Lihat">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('admin.lowongan.edit', $item->id)); ?>" 
                                                   class="btn btn-sm btn-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('admin.lowongan.destroy', $item->id)); ?>" 
                                                      method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger" 
                                                            title="Hapus"
                                                            onclick="return confirm('Yakin ingin menghapus lowongan ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        <?php echo e($lowongan->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-briefcase fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Belum ada lowongan kerja</h5>
                        <p class="text-muted">Mulai dengan menambahkan lowongan kerja pertama</p>
                        <a href="<?php echo e(route('admin.lowongan.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Tambah Lowongan
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Quick Stats -->
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4><?php echo e($lowongan->total()); ?></h4>
                        <p class="mb-0">Total Lowongan</p>
                    </div>
                    <i class="fas fa-briefcase fa-2x opacity-75"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4><?php echo e(\App\Models\Lowongan::where('status', 'aktif')->where(function($q) { $q->whereNull('deadline')->orWhere('deadline', '>=', now()); })->count()); ?></h4>
                        <p class="mb-0">Lowongan Aktif</p>
                    </div>
                    <i class="fas fa-check-circle fa-2x opacity-75"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4><?php echo e(\App\Models\Lowongan::where('status', 'aktif')->where('deadline', '<', now())->count()); ?></h4>
                        <p class="mb-0">Sudah Expired</p>
                    </div>
                    <i class="fas fa-clock fa-2x opacity-75"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4><?php echo e(\App\Models\Lowongan::where('deadline', '>=', now())->where('deadline', '<=', now()->addDays(7))->count()); ?></h4>
                        <p class="mb-0">Deadline 7 Hari</p>
                    </div>
                    <i class="fas fa-calendar-alt fa-2x opacity-75"></i>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/admin/lowongan/index.blade.php ENDPATH**/ ?>